/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ha;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOHashTable<K, V>
implements Map<K, V> {
    private static Log logger = LogFactory.getLog(TOHashTable.class);
    private int timeout = 600000;
    private final ProcessThread processThread;
    private final Map<K, Info> map = new ConcurrentHashMap<K, Info>();

    public TOHashTable(int timeout) {
        this.timeout = timeout * 1000;
        this.processThread = new ProcessThread(this.map);
        this.processThread.setDaemon(true);
        this.processThread.start();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public V put(K key, V o) {
        Info i = new Info(o, System.currentTimeMillis() + (long)this.timeout);
        Info previous = this.map.put(key, i);
        if (previous != null) {
            return previous.o;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        Info i = this.map.get(key);
        if (i != null) {
            return i.o;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Info i = this.map.remove(key);
        if (i != null) {
            return i.o;
        }
        return null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessThread
    extends Thread {
        private volatile Thread test;
        private final Map<K, Info> table;

        public ProcessThread(Map<K, Info> table) {
            this.table = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"ProcessMessage thread started", new Object[0]);
            this.test = Thread.currentThread();
            long currentTime = System.currentTimeMillis();
            while (this.test == Thread.currentThread()) {
                int removed = 0;
                Iterator<Info> i = this.table.values().iterator();
                while (i.hasNext()) {
                    Info info = i.next();
                    if (info.timeoutMoment > currentTime) continue;
                    i.remove();
                    if (!logger.isDebugEnabled()) continue;
                    ++removed;
                }
                if (removed > 0) {
                    logger.debug((Object)"Removed: {0} objects from TOHashTable.", new Object[]{removed});
                }
                ProcessThread processThread = this;
                synchronized (processThread) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        this.test = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopExecution() {
            logger.debug((Object)"ProcessMessage thread stoped", new Object[0]);
            ProcessThread processThread = this;
            synchronized (processThread) {
                this.test = null;
                this.notify();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Info {
        V o;
        long timeoutMoment = 0L;

        Info(V o, long timeoutMoment) {
            this.o = o;
            this.timeoutMoment = timeoutMoment;
        }
    }
}

