/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 * Copyright (C) 2006 Distributed Systems Lab.
 * Universidad Polit??cnica de Madrid (Spain)
 * Contact: http://lsd.ls.fi.upm.es/lsd
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 *
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.cmi.ha;

/**
 * MBean Interface for HAService.
 * MBean type: Standard
 * MBean model: Inheritance (HaServiceImpl)
 *
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public interface ReplicationManagerImplMBean {
    /**
     * @return the name of this bean
     */
    String getName();

    /**
     * @return Object Name
     */
    String getobjectName();

    /**
     * Get the number of replicated messages sent.
     * @return the number of replicated messages
     */
    long getnumberofReplicatedMessages();

    /**
     * Get the average size of the replicated messages sent.
     * @return the number of replicated messages
     */
    double getavgSizeofReplicatedMessages();

    /**
     * Get the total size of the replicated messages sent.
     * @return the total size of the replicated messages
     */
    double gettotSizeofReplicatedMessages();

    /**
     * Get the JGroups configuration file name.
     * @return the JGroups configuration file name
     */
    String getjgroupsConfFileName();

    /**
     * Get the SFSB info timeout to clean certain information stored in memory.
     * @return the timeout that
     */
    long getinfoTimeout();

    /**
     * Set the SFSB info timeout. The info stored in the node is removed when
     * the timer expires.
     * @param timeout the timeout to clean the info
     */
    void setinfoTimeout(long timeout);

    /**
     * Get the Datasource name required to hold the EB version numbers of the
     * horizontal replication approach.
     * @return the Datasource name
     */
    String getdatasourceName();

    /**
     * Set the Datasource name required to hold the EB version numbers of the
     * horizontal replication approach.
     * @param name the name of the datasource
     */
    void setdatasourceName(String name);
}
