/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: RequestId.java 1297 2007-10-08 12:09:10Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

import java.io.Serializable;

/**
 * This class is the key to identify the client requests in HA tables. It
 * is constructed in the JSessionRemote from the information received through
 * the HA interceptors. RequestId = ObjectId + Request_Number
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class RequestId implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 3288124644672329697L;

    /**
     * Object id representing the first bean contacted in the request
     */
    private SessionId objectId;

    /**
     * The request number to the bean represented by objectId
     */
    private int requestNo;

    /**
     * hashcode
     */
    private transient int hash = 0;

    /**
     * Constructor
     * @param objectId
     * @param requestNo
     */
    public RequestId(final SessionId objectId, final int requestNo) {
        this.objectId = objectId;
        this.requestNo = requestNo;
    }

    /**
     * Get the objectId
     * @return return the objectId
     */
    public SessionId getObjectId() {
        return objectId;
    }

    /**
     * Set the objectId
     * @param objectId
     */
    public void setObjectId(final SessionId objectId) {
        this.objectId = objectId;
    }

    /**
     * Get the request number
     * @return return the request number
     */
    public int getRequestNo() {
        return requestNo;
    }

    /**
     * Set the request number
     * @param requestNo
     */
    public void setRequestNo(final int requestNo) {
        this.requestNo = requestNo;
    }

    @Override
    public String toString() {
        return objectId + "/" + requestNo;
    }

    /**
     * Compute hashcode
     * @return hashcode
     */
    @Override
    public int hashCode() {
        if (hash != 0) {
            return hash;
        }
        int h = objectId.hashCode() + requestNo;
        hash = h;
        return h;
    }

    /**
     * Test if two RequestIds are equals
     * @param o object to compare with this
     * @return true if equals
     */
    @Override
    public boolean equals(final Object o) {
        if (o!=null && o instanceof RequestId) {
            RequestId i = (RequestId) o;
            return objectId.equals(i.objectId) && requestNo == i.requestNo;
        }
        return false;
    }
}
