/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: ActiveExecutionObject.java 1293 2007-10-07 09:52:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

import java.util.Vector;

/**
 * This class implements the data associated with an execution.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class ActiveExecutionObject {

    private RequestId reqId;

    private Vector<BeanInfo> beans = new Vector<BeanInfo>();

    private Vector<EntityBeanReference> entityBeans = new Vector<EntityBeanReference>();

    private Object response;

    /**
     * @param reqId
     * @param beans
     * @param response
     */
    public ActiveExecutionObject(final RequestId reqId, final Vector<BeanInfo> beans, final Object response) {
        this.reqId = reqId;
        this.beans = beans;
        this.response = response;
    }

    /**
     * @return Returns the beans.
     */
    public Vector<BeanInfo> getBeans() {
        return beans;
    }

    /**
     * @param beans The beans to set.
     */
    public void setBeans(final Vector<BeanInfo> beans) {
        this.beans = beans;
    }

    /**
     * @return Returns the beans.
     */
    public Vector<EntityBeanReference> getEntityBeans() {
        return entityBeans;
    }

    /**
     * @param beans The beans to set.
     */
    public void setEntityBeans(final Vector<EntityBeanReference> beans) {
        this.entityBeans = beans;
    }

    /**
     * @return Returns the reqId.
     */
    public RequestId getReqId() {
        return reqId;
    }

    /**
     * @param reqId The reqId to set.
     */
    public void setReqId(final RequestId reqId) {
        this.reqId = reqId;
    }

    /**
     * @return Returns the response.
     */
    public Object getResponse() {
        return response;
    }

    /**
     * @param response The response to set.
     */
    public void setResponse(final Object response) {
        this.response = response;
    }
}
