/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: JGViewManager.java 1293 2007-10-07 09:52:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

import org.jgroups.Address;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * This class processes the JGroups' membership messages.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class JGViewManager implements MembershipListener {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(JGViewManager.class);

    public JGViewManager() { }

    public void viewAccepted(final View arg0) {
            logger.debug("--------------------------------------------------");
            logger.debug("New view accepted " + arg0);
            logger.debug("--------------------------------------------------");
    }

    public void suspect(final Address arg0) { }

    public void block() { }

}
