/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: MessageManager.java 1293 2007-10-07 09:52:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

public interface MessageManager {

    /**
     * Sends a message.
     * @param messageData the message
     */
    void sendMessage(HaMessageData messageData);

    /**
     * Clear the GCS.
     *
     */
    void clear();

    /**
     * Get the number of replicated messages sent.
     * @return the number of replicated messages
     */
    long getNumberofReplicatedMessages();

    /**
     * Get the average size of the replicated messages sent.
     * @return the number of replicated messages
     */
    double getAvgSizeofReplicatedMessages();

    /**
     * Get the total size of the replicated messages sent.
     * @return the total size of the replicated messages
     */
    double getTotSizeofReplicatedMessages();

    /**
     * Get the JGroups configuration file name.
     * @return the JGroups configuration file name
     */
    String jgroupsConfFileName();
}
