/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Politecnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: ReplicationManager.java 1293 2007-10-07 09:52:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

/**
 * Interface with the replication functionality.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public interface ReplicationManager {

    // Primary methods

    /**
     * Correlates the changes made on a modified bean with a concrete client request.
     * @param reqId the request id from the client
     * @param bid the unique identifier for the instance
     * @param bean the bean reference
     */
    void addModifiedBean(RequestId reqId, SessionId bid, StatefulBeanReference bean);

    /**
     * Correlates the changes made on a modified bean with a concrete client request.
     * @param reqId the request id from the client
     * @param bean the bean reference
     */
    void addEntityBean(RequestId reqId, EntityBeanReference bean);

    /**
     * Associate a response with a requestId.
     * @param reqId the request id
     * @param response the response
     */
    void addResponse(RequestId reqId, Object response);

    /**
     * Replicates the changes made on beans inside a concrete request context.
     * @param reqId the request id
     * @throws ReplicationException
     */
    void replicate(RequestId reqId) throws ReplicationException;

    /**
     * Replicates the commit/abort message associate with a request.
     * @param reqId the request id
     * @param committed true if the transaction has committed
     * @throws ReplicationException
     */
    void replicateCommit(RequestId reqId, boolean committed) throws ReplicationException;


    // Backup Methods
    /**
     * Returns true if the request id have an associated response, false in other case.
     * @param reqId the request id
     * @return true if the request id have an associated response, false in other case
     */
    boolean hasBackupResponse(RequestId reqId);

    /**
     * Returns the response associated with the request id.
     * Returns null if there is not response associated
     * @param reqId
     * @return the associated response
     */
    Object getBackupResponse(RequestId reqId);

    /**
     * Restores the state for a bean through its remote interface. This will
     * probably made on a backup server when it has been selected to be the new
     * primary.
     * @param clusterOID the cluster object id
     * @param bean the sfsw that contains the instance where restore the state
     */
    void restoreBeanChanges(SessionId clusterOID,  StatefulBeanReference bean);

    /**
     * Processes a message data.
     * @param data the message data
     */
    void processMessage(HaMessageData data);

    /**
     * Clears/removes the elements used by the concrete implementation.
     */
    void clear();

}
