/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: ResumableRunnable.java 1459 2007-10-25 14:23:40Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.controller.server.impl.jgroups;

/**
 * This interface provide a handle to the interface {@link Runnable} in order to resume a suspended execution.
 * @author The new CMI team
 */
public interface ResumableRunnable extends Runnable {

    /**
     * Resume an execution.
     */
    void resumeExecution();

    /**
     * Stop an execution.
     */
    void stopExecution();

}
