/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.server.impl.jgroups;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import javax.management.MBeanServer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.stack.IpAddress;
import org.ow2.carol.cmi.admin.MBeanUtils;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.controller.common.CMIThreadFactory;
import org.ow2.carol.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.carol.cmi.controller.server.DistributedObjectInfo;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.carol.cmi.controller.server.impl.jgroups.JGroupsClusterViewManagerException;
import org.ow2.carol.cmi.controller.server.impl.jgroups.JGroupsServerConfig;
import org.ow2.carol.cmi.controller.server.impl.jgroups.ResumableRunnable;
import org.ow2.carol.cmi.controller.server.impl.jgroups.SynchronizedDistributedTree;
import org.ow2.carol.cmi.lb.data.LBPolicyData;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class JGroupsClusterViewManager
extends AbsServerClusterViewManager
implements SynchronizedDistributedTree.DistributedTreeListener,
SynchronizedDistributedTree.ViewListener {
    private static final Log LOGGER = LogFactory.getLog(JGroupsClusterViewManager.class);
    private final SynchronizedDistributedTree distributedTree;
    private final IpAddress localAddress;
    @GuardedBy(value="PATHS_TO_DELETE")
    private final Set<String> PATHS_TO_DELETE = new HashSet<String>();
    private final Thread garbageThread;
    private final ResumableRunnable resumableRunnable;
    private final Object lock = new Object();

    private JGroupsClusterViewManager() throws Exception {
        String groupName = JGroupsServerConfig.getGroupName();
        LOGGER.debug((Object)"Group name: {0}", new Object[]{groupName});
        String stack = JGroupsServerConfig.getStack();
        LOGGER.debug((Object)"The stack is :{0}", new Object[]{stack});
        this.distributedTree = new SynchronizedDistributedTree(groupName, stack);
        this.distributedTree.addDistributedTreeListener(this);
        this.distributedTree.addViewListener(this);
        this.distributedTree.start();
        JChannel channel = (JChannel)this.distributedTree.getChannel();
        try {
            JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)MBeanUtils.getMBeanServer(), (String)MBeanUtils.getMBeanDomainName(), (String)(channel.getClusterName() + ",name=" + CMIConfig.getCMIAdminMBeanName()), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to register the channel to the MBean Server", new Object[]{e});
        }
        Address obj = this.distributedTree.getLocalAddress();
        if (obj == null) {
            LOGGER.error((Object)"Cannot get the local address", new Object[0]);
            throw new JGroupsClusterViewManagerException("Cannot get the local address");
        }
        if (!(obj instanceof IpAddress)) {
            String className = obj.getClass().getName();
            LOGGER.error((Object)"At this time only IP address are supported, and not: {0}.", new Object[]{className});
            throw new JGroupsClusterViewManagerException("At this timen only IP address are supported, and not: " + className);
        }
        this.localAddress = (IpAddress)obj;
        LOGGER.debug((Object)"IpAddress: {0}", new Object[]{this.localAddress});
        CMIThreadFactory cmiThreadFactory = this.getCmiThreadFactory();
        this.resumableRunnable = new ResumableRunnable(){
            private volatile boolean suspended;
            private volatile boolean stopped;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.suspended = false;
                this.stopped = false;
                while (!this.stopped) {
                    Object object = this;
                    synchronized (object) {
                        try {
                            while (this.suspended && !this.stopped) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.debug((Object)"Garbage collector interrupted", new Object[]{e});
                        }
                    }
                    LOGGER.debug((Object)"Cleaning the distributed tree...", new Object[0]);
                    object = JGroupsClusterViewManager.this.PATHS_TO_DELETE;
                    synchronized (object) {
                        Iterator it = JGroupsClusterViewManager.this.PATHS_TO_DELETE.iterator();
                        while (it.hasNext()) {
                            String pathToDelete = (String)it.next();
                            JGroupsClusterViewManager.this.removePath(pathToDelete);
                            it.remove();
                        }
                        this.suspended = true;
                    }
                }
                LOGGER.debug((Object)"Garbage collector stopped", new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resumeExecution() {
                LOGGER.debug((Object)"Garbage collector resumed", new Object[0]);
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.suspended = false;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stopExecution() {
                LOGGER.debug((Object)"Garbage collector stopping...", new Object[0]);
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.stopped = true;
                    this.notify();
                }
            }
        };
        this.garbageThread = cmiThreadFactory.newThread((Runnable)this.resumableRunnable);
    }

    private static JGroupsClusterViewManager getJGroupsClusterViewManager() throws Exception {
        JGroupsClusterViewManager jgroupsClusterViewManager = new JGroupsClusterViewManager();
        jgroupsClusterViewManager.garbageThread.start();
        return jgroupsClusterViewManager;
    }

    public void doStart() {
    }

    public void doStop() {
        this.resumableRunnable.stopExecution();
        String domain = MBeanUtils.getMBeanDomainName();
        JChannel channel = (JChannel)this.distributedTree.getChannel();
        String cluster_name = channel.getClusterName();
        String name = domain + ":type=channel,cluster=" + cluster_name + ",name=" + CMIConfig.getCMIAdminMBeanName();
        MBeanServer mBeanServer = MBeanUtils.getMBeanServer();
        try {
            JmxConfigurator.unregisterChannel((MBeanServer)mBeanServer, (String)name);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error when unregistering the channel with name {0} from the MBean server", new Object[]{cluster_name, e});
        }
        String tmp = domain + ":type=protocol,cluster=" + cluster_name + ",name=" + CMIConfig.getCMIAdminMBeanName();
        JmxConfigurator.unregisterProtocols((MBeanServer)mBeanServer, (JChannel)channel, (String)tmp);
        this.distributedTree.stop();
    }

    private void removePath(String pathToDelete) {
        this.distributedTree.remove(pathToDelete);
    }

    protected boolean containObject(String objectName) {
        return this.distributedTree.exists(this.getObjectPath(objectName));
    }

    protected DistributedObjectInfo getDistributedObjectInfo(String objectName) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        Serializable obj = this.distributedTree.get(objectPath);
        if (obj == null) {
            LOGGER.error((Object)"Unknown object with name {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Unknown object with name " + objectName);
        }
        try {
            return ((DistributedObjectInfo)obj).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Amazing bug... I don't believe it !");
        }
    }

    protected void setDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        String objectPath = this.getObjectPath(objectName);
        LOGGER.debug((Object)"Adding {0} at the path {1}", new Object[]{distributedObjectInfo, objectPath});
        LOGGER.debug((Object)"Old infos: {0}", new Object[]{this.distributedTree.get(objectPath)});
        this.distributedTree.reset(objectPath, (Serializable)distributedObjectInfo);
    }

    private void registerPath(CMIReference cmiReference) {
        String path = this.getCMIReferencePath(cmiReference);
        String hostname = this.localAddress.getIpAddress().getHostAddress();
        int port = this.localAddress.getPort();
        String address = this.getAddressPath(hostname, port);
        String instAddr = this.getInstAddrPath(address, cmiReference.getServerRef().getProtocol() + "_" + cmiReference.getObjectName());
        this.distributedTree.add(instAddr, (Serializable)((Object)path));
    }

    private void unRegisterPath(CMIReference cmiReference) {
        String hostname = this.localAddress.getIpAddress().getHostAddress();
        int port = this.localAddress.getPort();
        String address = this.getAddressPath(hostname, port);
        String instAddr = this.getInstAddrPath(address, cmiReference.getServerRef().getProtocol() + "_" + cmiReference.getObjectName());
        this.distributedTree.remove(instAddr);
    }

    public Set<ServerRef> getServerRefs(String protocolName) throws ServerClusterViewManagerException {
        HashSet<ServerRef> serverRefs = new HashSet<ServerRef>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName)) {
                    serverRefs.add(cmiRef.getServerRef());
                }
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(protocolName + " is unknown", (Throwable)e);
            }
        }
        return serverRefs;
    }

    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        String protoPath = this.getProtocolPath(objectPath, protocolName);
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        Vector<String> childrenNames = this.distributedTree.getChildrenNames(protoPath);
        if (childrenNames.isEmpty()) {
            LOGGER.error((Object)"Unknown object {0} or protocol {1}", new Object[]{objectName, protocolName});
            throw new ObjectNotFoundException("Unknown object " + objectName + " or protocol " + protocolName);
        }
        for (String childrenName : childrenNames) {
            CMIReference cmiReference = this.getCMIReference(protoPath, childrenName);
            if (!this.isServerBlackListed(cmiReference.getServerRef())) {
                cmiReferences.add(cmiReference);
                continue;
            }
            LOGGER.debug((Object)"Do not add {0} because the server with ref {1} is black listed", new Object[]{cmiReference, cmiReference.getServerRef()});
        }
        return cmiReferences;
    }

    public List<CMIReference> getCMIReferences(String objectName) throws ObjectNotFoundException {
        String objectPath = this.getObjectPath(objectName);
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        Vector<String> protocols = this.distributedTree.getChildrenNames(objectPath);
        if (protocols.isEmpty()) {
            LOGGER.error((Object)"Unknown object {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Unknown object " + objectName);
        }
        for (String p : protocols) {
            String protoPath = this.getProtocolPath(objectPath, p);
            Vector<String> instances = this.distributedTree.getChildrenNames(protoPath);
            for (String nodeName : instances) {
                cmiReferences.add(this.getCMIReference(protoPath, nodeName));
            }
        }
        return cmiReferences;
    }

    private CMIReference getCMIReference(String protocolPath, String nodeName) {
        String cmiReferencePath = this.getCMIReferencePath(protocolPath, nodeName);
        return (CMIReference)this.distributedTree.get(cmiReferencePath);
    }

    protected void addCMIReference(CMIReference cmiReference) {
        String path = this.getCMIReferencePath(cmiReference);
        this.distributedTree.add(path, (Serializable)cmiReference);
        this.registerPath(cmiReference);
    }

    public void removeCMIReference(CMIReference cmiReference) {
        LOGGER.debug((Object)"Removing {0}...", new Object[]{cmiReference});
        String objectName = cmiReference.getObjectName();
        String objectPath = this.getObjectPath(objectName);
        String refPath = this.getCMIReferencePath(cmiReference);
        String protocolPath = this.getProtocolPath(objectPath, cmiReference.getServerRef().getProtocol());
        this.distributedTree.remove(refPath);
        this.unRegisterPath(cmiReference);
        Vector<String> childrenNames = this.distributedTree.getChildrenNames(protocolPath);
        if (childrenNames.isEmpty()) {
            this.distributedTree.remove(objectPath);
        }
    }

    public Set<String> getClusterNames() {
        HashSet<String> clusterNames = new HashSet<String>();
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        for (String objectName : objectNames) {
            try {
                DistributedObjectInfo distributedObjectInfo = this.getDistributedObjectInfo(objectName);
                clusterNames.add(distributedObjectInfo.getClusterName());
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(objectName + " is missing !", (Throwable)e);
            }
        }
        return clusterNames;
    }

    public Set<String> getObjectNames(String clusterName) {
        HashSet<String> objectNamesInCluster = new HashSet<String>();
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        for (String objectName : objectNames) {
            try {
                DistributedObjectInfo distributedObjectInfo = this.getDistributedObjectInfo(objectName);
                if (!distributedObjectInfo.getClusterName().equals(clusterName)) continue;
                objectNamesInCluster.add(objectName);
            }
            catch (ObjectNotFoundException e) {
                throw new ServerClusterViewManagerException(objectName + " is missing !", (Throwable)e);
            }
        }
        return objectNamesInCluster;
    }

    public Set<String> getObjectNames() {
        Vector<String> objectNames = this.distributedTree.getChildrenNames(this.getObjectsPath());
        return new HashSet<String>(objectNames);
    }

    public int getDelayToRefresh() {
        return (Integer)this.distributedTree.get(this.getDelayPath());
    }

    public void setDelayToRefresh(int delay) {
        this.distributedTree.reset(this.getDelayPath(), Integer.valueOf(delay));
    }

    public boolean isPoolToEmpty(String objectName) {
        return this.distributedTree.exists(this.getPoolToEmptyPath(objectName));
    }

    public void addPoolToEmpty(String objectName) {
        this.distributedTree.add(this.getPoolToEmptyPath(objectName));
    }

    public void removePoolToEmpty(String objectName) {
        this.distributedTree.remove(this.getPoolToEmptyPath(objectName));
    }

    public boolean isServerBlackListed(ServerRef serverRef) {
        return this.distributedTree.exists(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    public void addServerToBlackList(ServerRef serverRef) {
        this.distributedTree.add(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    public void removeServerFromBlackList(ServerRef serverRef) {
        this.distributedTree.remove(this.getServerBlackListedPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
    }

    public int getLoadFactor(ServerRef serverRef) throws ServerNotFoundException {
        Serializable obj = this.distributedTree.get(this.getLoadFactorPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()));
        if (obj == null) {
            throw new ServerNotFoundException("Unknown server: " + serverRef, serverRef);
        }
        return (Integer)obj;
    }

    public void setLoadFactor(ServerRef serverRef, int loadFactor) {
        this.distributedTree.reset(this.getLoadFactorPath(serverRef.getInetAddress().getHostAddress() + "_" + serverRef.getPort()), Integer.valueOf(loadFactor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStats() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.distributedTree.exists(this.getNbClientsConnectedToProviderPath())) {
                this.distributedTree.add(this.getNbClientsConnectedToProviderPath(), Integer.valueOf(0));
            }
        }
    }

    public int getNbClientsConnectedToProvider() {
        return (Integer)this.distributedTree.get(this.getNbClientsConnectedToProviderPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            if (this.distributedTree.exists(this.getClientUUIDPath(uuid.toString()))) {
                return;
            }
            this.distributedTree.add(this.getClientUUIDPath(uuid.toString()));
            this.distributedTree.set(this.getNbClientsConnectedToProviderPath(), Integer.valueOf((Integer)this.distributedTree.get(this.getNbClientsConnectedToProviderPath()) + 1));
        }
    }

    private String getInstAddrPath(String address, String instRef) {
        return address + "/" + instRef;
    }

    private String getObjectPath(String objectName) {
        return this.getObjectsPath() + "/" + objectName;
    }

    private String getRootPath() {
        return "/root";
    }

    private String getObjectsPath() {
        return this.getRootPath() + "/objects";
    }

    private String getProtocolPath(String objectPath, String protocol) {
        return objectPath + "/" + protocol;
    }

    private String getCMIReferencePath(String protocolPath, String objectName) {
        return protocolPath + "/" + objectName;
    }

    private String getCMIReferencePath(CMIReference cmiReference) {
        return this.getProtocolPath(this.getObjectPath(cmiReference.getObjectName()), cmiReference.getServerRef().getProtocol()) + "/" + cmiReference.getServerRef().getInetAddress().getHostAddress() + "_" + cmiReference.getServerRef().getPort();
    }

    private String getAddressesPath() {
        return this.getRootPath() + "/addresses";
    }

    private String getAddressPath(String hostname, int port) {
        return this.getAddressesPath() + "/" + hostname + "/" + port;
    }

    private String getDelayPath() {
        return this.getRootPath() + "/delay";
    }

    private String getBlackListPath() {
        return this.getRootPath() + "/black_list";
    }

    private String getPoolToEmptyPath() {
        return this.getRootPath() + "/pool_to_empty";
    }

    private String getLoadFactorsPath() {
        return this.getRootPath() + "/load_factors";
    }

    private String getStatsPath() {
        return this.getRootPath() + "/stats";
    }

    private String getNbClientsConnectedToProviderPath() {
        return this.getStatsPath() + "/nbClientsOnProvider";
    }

    private String getClientUUIDPath() {
        return this.getStatsPath() + "/clientUUID";
    }

    private String getClientUUIDPath(String uuid) {
        return this.getClientUUIDPath() + "/" + uuid;
    }

    private String getPoolToEmptyPath(String objectName) {
        return this.getPoolToEmptyPath() + "/" + objectName;
    }

    private String getServerBlackListedPath(String serverName) {
        return this.getBlackListPath() + "/" + serverName;
    }

    private String getLoadFactorPath(String address) {
        return this.getLoadFactorsPath() + "/" + address;
    }

    @Override
    public void nodeAdded(String fqn, Serializable element) {
        LOGGER.debug((Object)"{0} has been added", new Object[]{fqn});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeModified(String fqn, Serializable oldElement, Serializable newElement) {
        LOGGER.debug((Object)"{0} has been modified", new Object[]{fqn});
        LOGGER.debug((Object)"Old element: {0} - New element: {1}", new Object[]{oldElement, newElement});
        if (newElement != null && newElement instanceof DistributedObjectInfo) {
            DistributedObjectInfo newDistributedObjectInfo;
            DistributedObjectInfo distributedObjectInfo = newDistributedObjectInfo = (DistributedObjectInfo)newElement;
            synchronized (distributedObjectInfo) {
                String objectName = newDistributedObjectInfo.getObjectName();
                LBPolicyData newLBPolicyData = newDistributedObjectInfo.getLBPolicyData();
                if (oldElement == null || !((DistributedObjectInfo)oldElement).getLBPolicyData().equals((Object)newLBPolicyData)) {
                    try {
                        this.updateLBPolicy(objectName);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Cannot update LBPolicy for object with name {0}", new Object[]{objectName, e});
                        throw new RuntimeException("Cannot update LBPolicy for object with name " + objectName, e);
                    }
                }
            }
        }
    }

    @Override
    public void nodeRemoved(String fqn) {
        LOGGER.debug((Object)"{0} has been removed", new Object[]{fqn});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(Vector<Address> newMbrs, Vector<Address> oldMbrs) {
        LOGGER.debug((Object)"view has changed", new Object[0]);
        for (Address oldMbr : oldMbrs) {
            IpAddress ipAddr = (IpAddress)oldMbr;
            InetAddress inetAddress = ipAddr.getIpAddress();
            String hostname = inetAddress.getHostAddress();
            int port = ipAddr.getPort();
            LOGGER.debug((Object)"Search instances on {0}:{1}", new Object[]{hostname, String.valueOf(port)});
            String addrPath = this.getAddressPath(hostname, port);
            Vector<String> childrenNames = this.distributedTree.getChildrenNames(addrPath);
            for (String instAddrName : childrenNames) {
                String instAddrPath = this.getInstAddrPath(addrPath, instAddrName);
                String pathToDelete = (String)((Object)this.distributedTree.get(instAddrPath));
                LOGGER.debug((Object)"Marking {0} to delete", new Object[]{pathToDelete});
                this.PATHS_TO_DELETE.add(pathToDelete);
            }
            LOGGER.debug((Object)"Marking {0} to delete...", new Object[]{addrPath});
            Set<String> set = this.PATHS_TO_DELETE;
            synchronized (set) {
                this.PATHS_TO_DELETE.add(addrPath);
                this.resumableRunnable.resumeExecution();
            }
        }
    }
}

