/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.server.impl.jgroups;

import java.net.URL;
import org.jgroups.ChannelException;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JGroupsServerConfig {
    private static final Log LOGGER = LogFactory.getLog(JGroupsServerConfig.class);
    private static final String JGROUPS_CONF_PROPERTY = "cmi.server.impl.jgroups.conf";
    private static final String GROUP_NAME_PROPERTY = "cmi.server.impl.jgroups.groupname";
    private static final String STACK_PROPERTY = "cmi.server.impl.jgroups.stack";
    private static final String DEFAULT_CONF_FILENAME = "jgroups-cmi.xml";
    private static final String DEFAULT_GROUP_NAME = "G1";
    private static String jGroupsConfProps = "jgroups-cmi.xml";
    private static String groupName = "G1";
    private static String stack = null;

    private JGroupsServerConfig() {
    }

    private static String getJGroupsConfProps() {
        String prop = CMIConfig.getCMIProperty((String)JGROUPS_CONF_PROPERTY);
        if (prop != null) {
            jGroupsConfProps = prop;
        }
        return jGroupsConfProps;
    }

    public static String getGroupName() {
        String prop = CMIConfig.getCMIProperty((String)GROUP_NAME_PROPERTY);
        if (prop != null) {
            groupName = prop;
        }
        return groupName;
    }

    public static String getStack() throws ChannelException {
        String prop = CMIConfig.getCMIProperty((String)STACK_PROPERTY);
        if (prop != null) {
            stack = prop;
        } else {
            String jgroupsConfFilename = JGroupsServerConfig.getJGroupsConfProps();
            LOGGER.debug((Object)"Load JGroups conf with file: {0}", new Object[]{jgroupsConfFilename});
            URL url = ClassLoader.getSystemClassLoader().getResource(jgroupsConfFilename);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(jgroupsConfFilename);
            }
            if (url == null) {
                url = JGroupsServerConfig.class.getResource(jgroupsConfFilename);
            }
            ProtocolStackConfigurator protocolStackConfigurator = ConfiguratorFactory.getStackConfigurator((URL)url);
            stack = protocolStackConfigurator.getProtocolStackString();
        }
        return stack;
    }
}

