/**
 * New CMI
 * Copyright (C) 2007,2008 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:JGroupsServerConfig.java 949 2007-06-02 17:24:33Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.controller.server.impl.jgroups;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import org.jgroups.ChannelException;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;


/**
 * Provide configuration for the JGroups implementation for the ServerClusterViewManager.
 * @author The new CMI team
 * @see JGroupsClusterViewManager
 */
public final class JGroupsServerConfig {

    /**
     * Logger.
     */
    private static final Log LOGGER = LogFactory.getLog(JGroupsServerConfig.class);


    /************* Start of property names ***************/

    /**
     * JGroups configuration file property name.
     */
    private static final String JGROUPS_CONF_PROPERTY = "cmi.server.impl.jgroups.conf";

    /**
     * The property name to define the group name to use by JGroups.
     */
    private static final String GROUP_NAME_PROPERTY = "cmi.server.impl.jgroups.groupname";

    /**
     * The property name to define the stack used by JGroups.
     */
    private static final String STACK_PROPERTY = "cmi.server.impl.jgroups.stack";


    /************* End of property names ***************/

    /**
     * Default filename for the configuration file.
     */
    private static final String DEFAULT_CONF_FILENAME = "jgroups-cmi.xml";

    /**
     * Default group name.
     */
    private static final String DEFAULT_GROUP_NAME = "G1";

    /**
     * JGroups configuration filename.
     */
    private static String jGroupsConfProps = DEFAULT_CONF_FILENAME;

    /**
     * Group name.
     */
    private static String groupName = DEFAULT_GROUP_NAME;

    /**
     * Stack.
     */
    private static String stack = null;

    /**
     * Private empty constructor because utility class.
     */
    private JGroupsServerConfig() {
    }

    /**
     * @return The JGroups configuration filename.
     */
    private static String getJGroupsConfProps() {
        String prop = CMIConfig.getCMIProperty(JGROUPS_CONF_PROPERTY);
        // Check the JGroups conf property
        if(prop != null) {
            jGroupsConfProps = prop;
        }
        return jGroupsConfProps;
    }

    /**
     * @return the group name
     */
    public static String getGroupName() {
        String prop = CMIConfig.getCMIProperty(GROUP_NAME_PROPERTY);
        // Check the JGroups group name property
        if(prop != null) {
            groupName = prop;
        }
        return groupName;
    }

    /**
     * @return the stack to use with the distributedTree
     * @throws ChannelException if the given file doesn't contain a valid stack
     */
    public static String getStack() throws ChannelException {

        String prop = CMIConfig.getCMIProperty(STACK_PROPERTY);
        if(prop != null) {
            stack = prop;
        } else {
            // Get the JGroups conf filename
            String jgroupsConfFilename = getJGroupsConfProps();

            String confDir = CMIConfig.getConfDir();

            URL url = null;

            if(confDir != null) {
                URI uri = new File(confDir, jgroupsConfFilename).toURI();
                try {
                    url = uri.toURL();
                } catch (MalformedURLException e) {
                    LOGGER.warn("Cannot get the url for the uri: {0}", uri, e);
                }
            }
            if(url == null) {
                url = ClassLoader.getSystemClassLoader().getResource(jgroupsConfFilename);
                if(url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(jgroupsConfFilename);
                    if(url == null) {
                        url = JGroupsServerConfig.class.getResource(jgroupsConfFilename);
                    }
                }
            }

            LOGGER.debug("Load JGroups conf with file: {0}", url);

            // Load the configuration
            ProtocolStackConfigurator protocolStackConfigurator =
                ConfiguratorFactory.getStackConfigurator(url);
            stack = protocolStackConfigurator.getProtocolStackString();
        }
        return stack;
    }

}
