/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: IIntercepted.java 1631 2008-02-20 18:18:45Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.controller.server.impl.jgroups;

import java.io.Serializable;
import java.util.Vector;

/**
 * Declare the methods of {@link org.ow2.externals.jgroups.IDistributedTree} for which invocations should be intercepted.
 * @author Loris Bouzonnet
 */
public interface IIntercepted {

    void stop();

    void add(String fqn);

    void add(String fqn, Serializable element);

    /** resets an existing node, useful after a merge when you want to tell other
     *  members of your state, but do not wish to remove and then add as two separate calls */
    void reset(String fqn, Serializable element);

    void remove(String fqn);

    void add(String fqn, Serializable element, int timeout);

    /** resets an existing node, useful after a merge when you want to tell other
     *  members of your state, but do not wish to remove and then add as two separate calls */
    void reset(String fqn, Serializable element, int timeout);

    void remove(String fqn, int timeout);

    boolean exists(String fqn);

    Serializable get(String fqn);

    void set(String fqn, Serializable element);

    void set(String fqn, Serializable element, int timeout);

    Vector<String> getChildrenNames(String fqn);

}
