/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.jndi.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManagerException;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManagerImpl;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.carol.cmi.info.CMIInfoRepository;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.cmi.jndi.ClusteredObject;
import org.ow2.carol.cmi.jndi.context.CMIContextException;
import org.ow2.carol.cmi.jndi.context.CMINamingException;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.decision.DecisionManager;
import org.ow2.carol.cmi.lb.policy.FirstAvailablePolicy;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.carol.cmi.rpc.CMIProxyFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class CMIContext
implements Context {
    private static final Log LOGGER = LogFactory.getLog(CMIContext.class);
    private final Context localContext;
    private final String initialContextFactoryName;
    private final String protocol;
    private final boolean serverModeEnabled;
    private final boolean replicationEnabled;
    private boolean localMode;
    private static ClusterViewManager clusterViewManager;
    private final List<ServerRef> serverRefs;
    private ILBPolicy<ServerRef> defaultLBPolicy;

    public CMIContext(List<ServerRef> serverRefs, String protocol, String initialContextFactoryName) throws CMINamingException {
        this.localContext = null;
        this.protocol = protocol;
        this.initialContextFactoryName = initialContextFactoryName;
        this.serverRefs = new ArrayList<ServerRef>(serverRefs);
        this.serverModeEnabled = false;
        this.replicationEnabled = false;
        LOGGER.debug((Object)"Getting the ClientClusterViewManager...", new Object[0]);
        try {
            clusterViewManager = ClientClusterViewManagerImpl.getClientClusterViewManager((String)initialContextFactoryName, (String)protocol, serverRefs);
            this.localMode = false;
        }
        catch (ClientClusterViewManagerException e) {
            LOGGER.debug((Object)"Cannot get the ClientClusterViewManager", new Object[]{e});
            LOGGER.warn((Object)"Local mode", new Object[0]);
            this.localMode = true;
            try {
                this.setDefaultLBPolicy();
            }
            catch (CMIContextException e1) {
                LOGGER.error((Object)"Cannot set the default LB policy", new Object[]{e1});
                CMINamingException ne = new CMINamingException("Cannot set the default LB policy");
                ne.setRootCause(e1);
                throw ne;
            }
        }
    }

    public CMIContext(ServerRef serverRef, String initialContextFactoryName, boolean replicationEnabled) throws CMINamingException {
        this.serverRefs = Collections.singletonList(serverRef);
        this.initialContextFactoryName = initialContextFactoryName;
        LOGGER.debug((Object)"ProviderURL of local context is {0}", new Object[]{serverRef});
        this.protocol = serverRef.getProtocol();
        this.replicationEnabled = replicationEnabled;
        this.serverModeEnabled = true;
        if (replicationEnabled) {
            try {
                clusterViewManager = AbsServerClusterViewManager.getServerClusterViewManager();
                if (!(clusterViewManager instanceof ServerClusterViewManager)) {
                    LOGGER.error((Object)"An instance of ClusterViewManager already existsand has not for type ServerClusterViewManager, but {0}", new Object[]{clusterViewManager.getClass().getName()});
                    CMINamingException ne = new CMINamingException("An instance of ClusterViewManager already existsand has not for type ServerClusterViewManager, but " + clusterViewManager.getClass().getName());
                    throw ne;
                }
                this.localMode = false;
            }
            catch (ServerClusterViewManagerException e) {
                LOGGER.error((Object)"Cannot get the ServerClusterViewManager", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot get the ServerClusterViewManager");
                ne.setRootCause(e);
                throw ne;
            }
        }
        try {
            clusterViewManager = ClientClusterViewManagerImpl.getClientClusterViewManager((String)initialContextFactoryName, (String)this.protocol, this.serverRefs);
            this.localMode = false;
        }
        catch (ClientClusterViewManagerException e) {
            LOGGER.debug((Object)"Cannot get the ClientClusterViewManager", new Object[]{e});
            LOGGER.warn((Object)"Local mode", new Object[0]);
            this.localMode = true;
            try {
                this.setDefaultLBPolicy();
            }
            catch (CMIContextException e1) {
                LOGGER.error((Object)"Cannot set the default LB policy", new Object[]{e1});
                CMINamingException ne = new CMINamingException("Cannot set the default LB policy");
                ne.setRootCause(e1);
                throw ne;
            }
        }
        this.localContext = this.getRealContext(serverRef.getProviderURL(), initialContextFactoryName);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws CMINamingException {
        LOGGER.debug((Object)"addToEnvironment {0}", new Object[]{propName});
        if (this.serverModeEnabled) {
            try {
                return this.localContext.addToEnvironment(propName, propVal);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot addToEnvironment {0}", new Object[]{propName, e});
                CMINamingException ne = new CMINamingException("Cannot addToEnvironment " + propName);
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot addToEnvironment because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void bind(Name name, Object obj) throws CMINamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws CMINamingException {
        LOGGER.debug((Object)"bind {0}", new Object[]{name});
        if (this.serverModeEnabled) {
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            try {
                this.localContext.bind(name, obj);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot bind {0}", new Object[]{name, e});
                CMINamingException ne = new CMINamingException("Cannot bind " + name);
                ne.setRootCause(e);
                throw ne;
            }
            if (this.replicationEnabled) {
                try {
                    this.bindIntoCluster(name, obj);
                }
                catch (CMIContextException e) {
                    LOGGER.error((Object)"Cannot add the object for name  {0} to the cluster", new Object[]{name});
                    CMINamingException ne = new CMINamingException("Cannot add the object for name {0} to the cluster" + name);
                    ne.setRootCause(e);
                    throw ne;
                }
            } else {
                LOGGER.debug((Object)"Replication is disabled", new Object[0]);
            }
        } else {
            LOGGER.warn((Object)"Cannot bind because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void close() throws CMINamingException {
        LOGGER.debug((Object)"close", new Object[0]);
        if (this.serverModeEnabled) {
            try {
                this.localContext.close();
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot close the context", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot close the context");
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            LOGGER.warn((Object)"Cannot close because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Name composeName(Name name, Name prefix) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.composeName(name, prefix);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot compose name", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot compose name");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot compose name because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.composeName(name, prefix);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot compose name", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot compose name");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot compose name because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public Context createSubcontext(Name name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.createSubcontext(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot create subcontext", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot create subcontext");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot create subcontext because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.createSubcontext(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot create subcontext", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot create subcontext");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot create subcontext because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                this.localContext.destroySubcontext(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot destroy subcontext", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot destroy subcontext");
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            LOGGER.warn((Object)"Cannot destroy subcontext because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void destroySubcontext(String name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                this.localContext.destroySubcontext(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot destroy subcontext", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot destroy subcontext");
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            LOGGER.warn((Object)"Cannot destroy subcontext because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.getEnvironment();
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot get environement", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot get environement");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot getEnvironement because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public String getNameInNamespace() throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.getNameInNamespace();
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot get name in namespace", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot get name in name space");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot getNameInNamespace because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.getNameParser(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot get name parser", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot get name parser");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot getNameParser because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.getNameParser(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot get name parser", new Object[]{e});
                CMINamingException ne = new CMINamingException("Cannot get name parser");
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot getNameParser because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        List loadBalanceables;
        ILBPolicy lbPolicy;
        if (this.serverModeEnabled) {
            return this.localContext.list(name);
        }
        if (!this.localMode) {
            String bindNameForDummyContext = CMIConfig.getBindNameForDummyRegistry();
            try {
                lbPolicy = clusterViewManager.getLBPolicy(bindNameForDummyContext);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{bindNameForDummyContext, e});
                CMINamingException ne = new CMINamingException("Cannot get LB policy for object " + bindNameForDummyContext);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = clusterViewManager.getCMIReferences(bindNameForDummyContext, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{bindNameForDummyContext, e});
                CMINamingException ne = new CMINamingException("Cannot get node list for " + bindNameForDummyContext);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultLBPolicy;
            loadBalanceables = this.serverRefs;
        }
        while (true) {
            LoadBalanceable loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{this.serverRefs, lbPolicy, e});
                CMINamingException ne = new CMINamingException("Cannot choose CMIReference in the list " + this.serverRefs + " with LB policy " + lbPolicy);
                ne.setRootCause(e);
                throw ne;
            }
            ServerRef serverRef = loadBalanceable instanceof CMIReference ? ((CMIReference)loadBalanceable).getServerRef() : (ServerRef)loadBalanceable;
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            try {
                return context.list(name);
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                DecisionManager decisionManager = lbPolicy.onLookupException(loadBalanceable, (Throwable)e);
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.debug((Object)"Throw: ", new Object[]{e});
                    throw e;
                }
                LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                loadBalanceables.remove(loadBalanceable);
                if (!loadBalanceables.isEmpty()) continue;
                LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                throw e;
            }
            break;
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        List loadBalanceables;
        ILBPolicy lbPolicy;
        if (this.serverModeEnabled) {
            return this.localContext.listBindings(name);
        }
        if (!this.localMode) {
            String bindNameForDummyContext = CMIConfig.getBindNameForDummyRegistry();
            try {
                lbPolicy = clusterViewManager.getLBPolicy(bindNameForDummyContext);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{bindNameForDummyContext, e});
                CMINamingException ne = new CMINamingException("Cannot get LB policy for object " + bindNameForDummyContext);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = clusterViewManager.getCMIReferences(bindNameForDummyContext, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{bindNameForDummyContext, e});
                CMINamingException ne = new CMINamingException("Cannot get node list for " + bindNameForDummyContext);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultLBPolicy;
            loadBalanceables = this.serverRefs;
        }
        while (true) {
            LoadBalanceable loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{this.serverRefs, lbPolicy, e});
                CMINamingException ne = new CMINamingException("Cannot choose CMIReference in the list " + this.serverRefs + " with LB policy " + lbPolicy);
                ne.setRootCause(e);
                throw ne;
            }
            ServerRef serverRef = loadBalanceable instanceof CMIReference ? ((CMIReference)loadBalanceable).getServerRef() : (ServerRef)loadBalanceable;
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            try {
                return context.listBindings(name);
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                DecisionManager decisionManager = lbPolicy.onLookupException(loadBalanceable, (Throwable)e);
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.debug((Object)"Throw: ", new Object[]{e});
                    throw e;
                }
                LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                loadBalanceables.remove(loadBalanceable);
                if (!loadBalanceables.isEmpty()) continue;
                LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                throw e;
            }
            break;
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        List loadBalanceables;
        ILBPolicy lbPolicy;
        if (!this.localMode) {
            LOGGER.debug((Object)"lookup {0} using ClusterViewManager", new Object[]{name});
            boolean isClustered = clusterViewManager.isClustered(name);
            if (isClustered) {
                CMIProxy cmiProxy;
                LOGGER.debug((Object)"{0} is clustered", new Object[]{name});
                try {
                    clusterViewManager.addObjectToWatch(name);
                }
                catch (ObjectNotFoundException e) {
                    LOGGER.error((Object)"Cannot add object {0} into the set of watched objects", new Object[]{name, e});
                    CMINamingException ne = new CMINamingException("Cannot add object " + name + " into the set of watched objects");
                    ne.setRootCause(e);
                    throw ne;
                }
                try {
                    cmiProxy = CMIProxyFactory.newCMIProxy((ClusterViewManager)clusterViewManager, (String)name, (String)this.protocol);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Cannot get a CMI proxy for {0}.", new Object[]{name, e});
                    CMINamingException ne = new CMINamingException("Cannot get a CMI proxy for " + name);
                    ne.setRootCause(e);
                    throw ne;
                }
                return cmiProxy;
            }
        }
        if (this.serverModeEnabled) {
            return this.localContext.lookup(name);
        }
        if (!this.localMode) {
            String bindNameForDummyRegistry = CMIConfig.getBindNameForDummyRegistry();
            try {
                lbPolicy = clusterViewManager.getLBPolicy(bindNameForDummyRegistry);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{bindNameForDummyRegistry, e});
                CMINamingException ne = new CMINamingException("Cannot get LB policy for object " + bindNameForDummyRegistry);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = clusterViewManager.getCMIReferences(bindNameForDummyRegistry, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{bindNameForDummyRegistry, e});
                CMINamingException ne = new CMINamingException("Cannot get node list for " + bindNameForDummyRegistry);
                ne.setRootCause(e);
                throw ne;
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultLBPolicy;
            loadBalanceables = this.serverRefs;
        }
        while (true) {
            LoadBalanceable loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{this.serverRefs, lbPolicy, e});
                CMINamingException ne = new CMINamingException("Cannot choose CMIReference in the list " + this.serverRefs + " with LB policy " + lbPolicy);
                ne.setRootCause(e);
                throw ne;
            }
            ServerRef serverRef = loadBalanceable instanceof CMIReference ? ((CMIReference)loadBalanceable).getServerRef() : (ServerRef)loadBalanceable;
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            try {
                return context.lookup(name);
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                DecisionManager decisionManager = lbPolicy.onLookupException(loadBalanceable, (Throwable)e);
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.debug((Object)"Throw: ", new Object[]{e});
                    throw e;
                }
                LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                loadBalanceables.remove(loadBalanceable);
                if (!loadBalanceables.isEmpty()) continue;
                LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                throw e;
            }
            break;
        }
    }

    @Override
    public Object lookupLink(Name name) throws CMINamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws CMINamingException {
        LOGGER.error((Object)"Not supproted", new Object[0]);
        throw new CMINamingException("Not suppported");
    }

    @Override
    public void rebind(Name name, Object obj) throws CMINamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws CMINamingException {
        LOGGER.debug((Object)"rebind {0}", new Object[]{name});
        if (this.serverModeEnabled) {
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            try {
                this.localContext.rebind(name, obj);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot rebind {0}", new Object[]{name, e});
                CMINamingException ne = new CMINamingException("Cannot rebind " + name);
                ne.setRootCause(e);
                throw ne;
            }
            if (this.replicationEnabled) {
                LOGGER.debug((Object)"CMI is enabled.", new Object[0]);
                try {
                    this.bindIntoCluster(name, obj);
                }
                catch (CMIContextException e) {
                    LOGGER.error((Object)"Cannot add the object for name  {0} to the cluster", new Object[]{name});
                    CMINamingException ne = new CMINamingException("Cannot add the object for name {0} to the cluster" + name);
                    ne.setRootCause(e);
                    throw ne;
                }
            } else {
                LOGGER.debug((Object)"Replication is disabled", new Object[0]);
            }
        } else {
            LOGGER.warn((Object)"Cannot rebind because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Object removeFromEnvironment(String propName) throws CMINamingException {
        if (this.serverModeEnabled) {
            try {
                return this.localContext.removeFromEnvironment(propName);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot remove from environement {0}", new Object[]{propName, e});
                CMINamingException ne = new CMINamingException("Cannot gremove from environement " + propName);
                ne.setRootCause(e);
                throw ne;
            }
        }
        LOGGER.warn((Object)"Cannot removeFromEnvironment because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void rename(Name oldName, Name newName) throws CMINamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws CMINamingException {
        LOGGER.debug((Object)"renaming {0}", new Object[]{oldName, newName});
        if (this.serverModeEnabled) {
            boolean isClustered;
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            if (this.replicationEnabled && (isClustered = clusterViewManager.isClustered(oldName))) {
                LOGGER.debug((Object)"{0} is clustered", new Object[]{oldName});
                throw new UnsupportedOperationException("Cannot rename in the cluster for now !");
            }
            try {
                this.localContext.rename(oldName, newName);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot rename {0}", new Object[]{oldName, e});
                CMINamingException ne = new CMINamingException("Cannot rename " + oldName);
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            LOGGER.warn((Object)"Cannot rename because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void unbind(Name name) throws CMINamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws CMINamingException {
        LOGGER.debug((Object)"unbind {0}", new Object[]{name});
        if (this.serverModeEnabled) {
            boolean isClustered;
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            if (this.replicationEnabled && (isClustered = clusterViewManager.isClustered(name))) {
                LOGGER.debug((Object)"{0} is clustered", new Object[]{name});
                ((ServerClusterViewManager)clusterViewManager).removeCMIReference(new CMIReference(this.serverRefs.get(0), name));
            }
            try {
                this.localContext.unbind(name);
            }
            catch (NamingException e) {
                LOGGER.error((Object)"Cannot unbind {0}", new Object[]{name, e});
                CMINamingException ne = new CMINamingException("Cannot unbind " + name);
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            LOGGER.warn((Object)"Cannot unbind because server mode is not activated.", new Object[0]);
        }
    }

    private void bindIntoCluster(String name, Object obj) throws CMIContextException {
        ClusteredObjectInfo clusteredObjectInfo;
        if (obj instanceof ClusteredObject) {
            ClusteredObject clusteredObject = (ClusteredObject)obj;
            clusteredObjectInfo = clusteredObject.getClusteredObjectInfo();
        } else if (CMIInfoRepository.containClusteredObjectInfo((String)name)) {
            clusteredObjectInfo = CMIInfoRepository.getClusteredObjectInfo((String)name);
        } else {
            LOGGER.debug((Object)"The object for name {0} will not be replicated.", new Object[]{name});
            return;
        }
        if (clusteredObjectInfo.isReplicated() && !((ServerClusterViewManager)clusterViewManager).isReplicationManagerStarted()) {
            LOGGER.warn((Object)"the replication manager should be started because the clustered object {0} has a state that must be replicated.", new Object[]{name});
        }
        CMIReference cmiReference = new CMIReference(this.serverRefs.get(0), name);
        try {
            ((ServerClusterViewManager)clusterViewManager).addObjectInstance(clusteredObjectInfo, cmiReference);
        }
        catch (ServerClusterViewManagerException e) {
            LOGGER.error((Object)"Cannot insert {0} into the cluster view", new Object[]{name, e});
            throw new CMIContextException("Cannot insert " + name + " into the cluster view", e);
        }
    }

    private void setDefaultLBPolicy() throws CMIContextException {
        try {
            this.defaultLBPolicy = (ILBPolicy)FirstAvailablePolicy.class.newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot construct the default LB policy", new Object[]{e});
            throw new CMIContextException("Cannot construct the default LB policy", e);
        }
    }

    private Context getRealContext(String providerUrl, String initialContextFactoryName) throws CMINamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactoryName);
        env.put("java.naming.provider.url", providerUrl);
        try {
            return new InitialContext(env);
        }
        catch (NamingException e) {
            CMINamingException ne = new CMINamingException("Cannot create an initial context");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void register() throws CMIContextException {
        if (!(clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Cannot register a CMIContext with a client manager", new Object[0]);
            throw new CMIContextException("Cannot register a CMIContext with a client manager");
        }
        try {
            ((ServerClusterViewManager)clusterViewManager).addProtocol(this.initialContextFactoryName, this.serverRefs.get(0), (Context)this);
        }
        catch (ServerClusterViewManagerException e) {
            LOGGER.error((Object)"Cannot register the context", new Object[]{e});
            throw new CMIContextException("Cannot register the context", e);
        }
    }
}

