/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.jndi.context;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.config.CMIConfigException;
import org.ow2.carol.cmi.config.CMIPropertyHelper;
import org.ow2.carol.cmi.jndi.context.CMIContext;
import org.ow2.carol.cmi.jndi.context.CMIContextException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CMIInitialContextFactory
implements InitialContextFactory {
    private static Log logger = LogFactory.getLog(CMIInitialContextFactory.class);
    private String protocol;

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        boolean isServer = this.isServerMode(environment);
        if (isServer && !CMIConfig.isConfigured()) {
            Properties cmiProps = this.extractCMIConfig(environment);
            try {
                if (cmiProps != null) {
                    CMIConfig.setProperties((Properties)cmiProps);
                } else {
                    CMIConfig.init();
                }
            }
            catch (CMIConfigException e) {
                logger.error((Object)"Cannot initialize CMI", new Object[0]);
                NamingException ne = new NamingException("Cannot initialize CMI");
                ne.setRootCause(e);
                throw ne;
            }
        }
        this.protocol = this.extractProtocol(environment);
        String wrappedFactoryName = this.extractWrappedFactoryName(environment);
        List<ServerRef> initialProviderURLs = this.extractServerRefs(environment);
        if (!isServer) {
            logger.debug((Object)"Context client is returned", new Object[0]);
            return new CMIContext(initialProviderURLs, this.protocol, wrappedFactoryName);
        }
        int size = initialProviderURLs.size();
        if (size == 0) {
            logger.error((Object)"No providerURL found", new Object[0]);
            throw new NamingException("No providerURL found");
        }
        if (size > 1) {
            logger.warn((Object)"Only one providerURL is expected: the first is used.", new Object[0]);
        }
        boolean replicationEnabled = CMIConfig.isReplicationEnabled();
        CMIContext cmiContext = new CMIContext(initialProviderURLs.get(0), wrappedFactoryName, replicationEnabled);
        if (replicationEnabled) {
            try {
                cmiContext.register();
            }
            catch (CMIContextException e) {
                logger.error((Object)"Cannot register the context", new Object[0]);
                NamingException ne = new NamingException("Cannot register the context");
                ne.setRootCause(e);
                throw ne;
            }
        }
        return cmiContext;
    }

    private Properties extractCMIConfig(Hashtable<?, ?> environment) {
        Properties cmiProps = new Properties();
        boolean containCMIConfig = false;
        for (Object obj : environment.keySet()) {
            if (!(obj instanceof String)) continue;
            String name = (String)obj;
            Object value = environment.get(obj);
            if (!(value instanceof String)) continue;
            cmiProps.setProperty(name, (String)value);
            if (!CMIPropertyHelper.containProperty((String)name)) continue;
            containCMIConfig = true;
        }
        if (!containCMIConfig) {
            logger.debug((Object)"No CMI property found", new Object[0]);
            return null;
        }
        logger.debug((Object)("CMI properties found: " + cmiProps), new Object[0]);
        return cmiProps;
    }

    private String extractProtocol(Hashtable<?, ?> environment) throws NamingException {
        Object obj = environment.get("cmi.context.wrapped.protocol");
        if (obj == null) {
            logger.error((Object)"Property {0} is missing.", new Object[]{"cmi.context.wrapped.protocol"});
            throw new NamingException("Property cmi.context.wrapped.protocol is missing.");
        }
        return (String)obj;
    }

    private String extractWrappedFactoryName(Hashtable<?, ?> environment) throws NamingException {
        Object obj = environment.get("cmi.context.wrapped.factory");
        if (obj == null) {
            logger.error((Object)"Property {0} is missing.", new Object[]{"cmi.context.wrapped.factory"});
            throw new NamingException("Property cmi.context.wrapped.factory is missing.");
        }
        return (String)obj;
    }

    private List<ServerRef> extractServerRefs(Hashtable<?, ?> environment) throws NamingException {
        Object obj = environment.get("cmi.context.provider.urls");
        if (obj == null) {
            logger.error((Object)"Property {0} is missing.", new Object[]{"cmi.context.provider.urls"});
            throw new NamingException("Property cmi.context.provider.urls is missing.");
        }
        ArrayList<ServerRef> serverRefs = new ArrayList<ServerRef>();
        for (String providerURL : (List)obj) {
            try {
                serverRefs.add(new ServerRef(this.protocol, providerURL));
            }
            catch (MalformedURLException e) {
                logger.error((Object)"The following provider URL is malformed {0}", new Object[]{providerURL});
                NamingException ne = new NamingException("The following provider URL is malformed " + providerURL);
                ne.setRootCause(e);
                throw ne;
            }
            catch (UnknownHostException e) {
                logger.error((Object)"The host name of the provider URL {0} cannot be resolved", new Object[]{providerURL});
                NamingException ne = new NamingException("The host name of the provider URL " + providerURL + " cannot be resolved");
                ne.setRootCause(e);
                throw ne;
            }
        }
        return serverRefs;
    }

    private boolean isServerMode(Hashtable<?, ?> environment) {
        Object obj = environment.get("cmi.mode.server");
        if (obj == null) {
            logger.warn((Object)"Property {0} is not defined: use the default value 'false'", new Object[]{"cmi.mode.server"});
            return false;
        }
        return (Boolean)obj;
    }
}

