/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id:LBPropertyData.java 1334 2007-10-19 14:44:36Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.lb.data;

import java.lang.reflect.Method;
import java.lang.reflect.Type;

import net.jcip.annotations.Immutable;

import org.ow2.carol.cmi.lb.PropertyConfigurationException;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 *
 * @author The new CMI team
 */
@SuppressWarnings("unchecked")
@Immutable
public class LBPropertyData {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(LBPropertyData.class);

    private final String lbPropertyName;

    private final Class<? extends ILBPolicy> lbPolicyClass;

    private final Type lbPropertyType;

    private final Method getter;

    private final Method setter;

    public LBPropertyData(
            final String lbPropertyName,
            final Class<? extends ILBPolicy> lbPolicyClass)
    throws PropertyConfigurationException {
        this.lbPropertyName = lbPropertyName;
        this.lbPolicyClass = lbPolicyClass;
        String formattedPropertyName =
            lbPropertyName.substring(0, 1).toUpperCase()
            + lbPropertyName.substring(1);
        try {
            getter =
                lbPolicyClass.getDeclaredMethod(
                        "get" + formattedPropertyName);
            lbPropertyType = getter.getGenericReturnType();
            setter =
                lbPolicyClass.getDeclaredMethod(
                        "set"+formattedPropertyName, getter.getReturnType());
        } catch (Exception e) {
            logger.error(
                    "The class for name {0} doesn't contain the property {1}",
                    lbPolicyClass.getName(), lbPropertyName, e);
            throw new PropertyConfigurationException(
                    "The class for name "+lbPolicyClass.getName()+
                    "doesn't contain the property "+lbPropertyName, e);
        }
        Type[] parameterTypes = setter.getGenericParameterTypes();
        if(!parameterTypes[0].equals(lbPropertyType)) {
            logger.error("Setter and getter doesn't have the same type !");
            throw new PropertyConfigurationException(
            "Setter and getter doesn't have the same type !");
        }
    }

    public LBPropertyData(
            final Method getter,
            final Class<? extends ILBPolicy> lbPolicyClass)
    throws PropertyConfigurationException {
        this.getter = getter;
        this.lbPolicyClass = lbPolicyClass;
        String formattedPropertyName = getter.getName().substring(3);
        lbPropertyName =
            formattedPropertyName.substring(0, 1).toLowerCase()
            + formattedPropertyName.substring(1);
        lbPropertyType = getter.getGenericReturnType();
        try {
            setter =
                lbPolicyClass.getDeclaredMethod(
                        "set" + formattedPropertyName, getter.getReturnType());
        } catch (Exception e) {
            logger.error(
                    "The class for name {0} doesn't contain a setter for property {1}",
                    lbPolicyClass.getName(), lbPropertyName, e);
            throw new PropertyConfigurationException(
                    "The class for name "+lbPolicyClass.getName()+
                    "doesn't contain a setter for property "+lbPropertyName, e);
        }
        Type[] parameterTypes = setter.getGenericParameterTypes();
        if(!parameterTypes[0].equals(lbPropertyType)) {
            logger.error("Setter and getter doesn't have the same type !");
            throw new PropertyConfigurationException(
            "Setter and getter doesn't have the same type !");
        }
    }

    public String getLbPropertyName() {
        return lbPropertyName;
    }

    public Class<? extends ILBPolicy> getLbPolicyClass() {
        return lbPolicyClass;
    }

    public Type getLbPropertyType() {
        return lbPropertyType;
    }

    public Method getGetter() {
        return getter;
    }

    public Method getSetter() {
        return setter;
    }

}
