/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.data;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.jcip.annotations.Immutable;
import org.ow2.carol.cmi.lb.PropertyConfigurationException;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LBPropertyData {
    private static Log logger = LogFactory.getLog(LBPropertyData.class);
    private final String lbPropertyName;
    private final Class<? extends ILBPolicy> lbPolicyClass;
    private final Type lbPropertyType;
    private final Method getter;
    private final Method setter;

    public LBPropertyData(String lbPropertyName, Class<? extends ILBPolicy> lbPolicyClass) throws PropertyConfigurationException {
        this.lbPropertyName = lbPropertyName;
        this.lbPolicyClass = lbPolicyClass;
        String formattedPropertyName = lbPropertyName.substring(0, 1).toUpperCase() + lbPropertyName.substring(1);
        try {
            this.getter = lbPolicyClass.getDeclaredMethod("get" + formattedPropertyName, new Class[0]);
            this.lbPropertyType = this.getter.getGenericReturnType();
            this.setter = lbPolicyClass.getDeclaredMethod("set" + formattedPropertyName, this.getter.getReturnType());
        }
        catch (Exception e) {
            logger.error((Object)"The class for name {0} doesn't contain the property {1}", new Object[]{lbPolicyClass.getName(), lbPropertyName, e});
            throw new PropertyConfigurationException("The class for name " + lbPolicyClass.getName() + "doesn't contain the property " + lbPropertyName, (Throwable)e);
        }
        Type[] parameterTypes = this.setter.getGenericParameterTypes();
        if (!parameterTypes[0].equals(this.lbPropertyType)) {
            logger.error((Object)"Setter and getter doesn't have the same type !", new Object[0]);
            throw new PropertyConfigurationException("Setter and getter doesn't have the same type !");
        }
    }

    public LBPropertyData(Method getter, Class<? extends ILBPolicy> lbPolicyClass) throws PropertyConfigurationException {
        this.getter = getter;
        this.lbPolicyClass = lbPolicyClass;
        String formattedPropertyName = getter.getName().substring(3);
        this.lbPropertyName = formattedPropertyName.substring(0, 1).toLowerCase() + formattedPropertyName.substring(1);
        this.lbPropertyType = getter.getGenericReturnType();
        try {
            this.setter = lbPolicyClass.getDeclaredMethod("set" + formattedPropertyName, getter.getReturnType());
        }
        catch (Exception e) {
            logger.error((Object)"The class for name {0} doesn't contain a setter for property {1}", new Object[]{lbPolicyClass.getName(), this.lbPropertyName, e});
            throw new PropertyConfigurationException("The class for name " + lbPolicyClass.getName() + "doesn't contain a setter for property " + this.lbPropertyName, (Throwable)e);
        }
        Type[] parameterTypes = this.setter.getGenericParameterTypes();
        if (!parameterTypes[0].equals(this.lbPropertyType)) {
            logger.error((Object)"Setter and getter doesn't have the same type !", new Object[0]);
            throw new PropertyConfigurationException("Setter and getter doesn't have the same type !");
        }
    }

    public String getLbPropertyName() {
        return this.lbPropertyName;
    }

    public Class<? extends ILBPolicy> getLbPolicyClass() {
        return this.lbPolicyClass;
    }

    public Type getLbPropertyType() {
        return this.lbPropertyType;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }
}

