/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id:DecisionUtil.java 1123 2007-07-27 10:07:09Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.lb.decision;

import java.io.EOFException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnmarshalException;

import javax.naming.NameNotFoundException;
import javax.naming.ServiceUnavailableException;

import net.jcip.annotations.Immutable;

import org.ow2.carol.cmi.pool.NamingPoolException;

/**
 * Utilities for failover.
 * @author The new CMI team
 */
@Immutable
public final class DecisionUtil {

    /**
     * Private default constructor.
     */
    private DecisionUtil() {
    }

    /**
     * Checks if the distributor must fail over depending of the exception.
     * @param ex The exception to check
     * @return true if the distributor must fail over
     */
    public static boolean mustFailoverOnInvoke(final Throwable ex) {

        Throwable cause = ex;

        // Extract cause from UndeclaredThrowableException and InvocationTargetException
        while(cause instanceof UndeclaredThrowableException
                || cause instanceof InvocationTargetException) {
            if(cause instanceof UndeclaredThrowableException) {
                cause = ((UndeclaredThrowableException) cause).getUndeclaredThrowable();
            } else if(cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException) cause).getTargetException();
            }
        }
        if (cause instanceof UnmarshalException) {
            cause = cause.getCause();
            if ((cause instanceof EOFException)
                    || (cause instanceof SocketException)) {
                return true;
            }
        }
        if (cause instanceof ConnectException
                || cause instanceof ConnectIOException
                || cause instanceof NoSuchObjectException
                || cause instanceof org.omg.CORBA.TRANSIENT
                || cause instanceof org.omg.CORBA.COMM_FAILURE) {
            return true;
        }
        return false;
    }

    /**
     * Checks if the distributor must fail over depending of the exception.
     * @param ex The exception to check
     * @return true if the distributor must fail over
     */
    public static boolean mustFailoverOnLookup(final Throwable ex) {

        Throwable cause = ex;

        if(cause instanceof NamingPoolException) {
            cause = ((NamingPoolException) cause).getCause();
        }

        if(cause instanceof NameNotFoundException
                || cause instanceof ServiceUnavailableException
                || cause instanceof org.omg.CORBA.TRANSIENT
                || cause instanceof org.omg.CORBA.COMM_FAILURE) {
            return true;
        }
        return false;
    }

}
