/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.decision.BasicDecisionManager;
import org.ow2.carol.cmi.lb.decision.DecisionUtil;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class FirstAvailablePolicy<T extends LoadBalanceable>
implements ILBPolicy<T> {
    private static final long serialVersionUID = -2189951403453152654L;
    private static final Log LOGGER = LogFactory.getLog(FirstAvailablePolicy.class);
    private T nodeSelected = null;
    private final Random nodeRandom = new Random();
    private ILBStrategy<T> lbStrategy = null;

    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List cmiRefsWithStrategy;
        if (loadBalanceables.size() == 0) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        if (this.lbStrategy != null) {
            cmiRefsWithStrategy = this.lbStrategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        if (this.nodeSelected != null && cmiRefsWithStrategy.contains(this.nodeSelected)) {
            return this.nodeSelected;
        }
        int index = this.nodeRandom.nextInt(cmiRefsWithStrategy.size());
        this.nodeSelected = (LoadBalanceable)cmiRefsWithStrategy.get(index);
        LOGGER.debug((Object)"New reference selected {1} at index {0}", new Object[]{index, this.nodeSelected});
        return this.nodeSelected;
    }

    public BasicDecisionManager<Void> onInvokeException(Method method, Object[] parameters, T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnInvoke(thr)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    public <ReturnType> BasicDecisionManager<ReturnType> onReturn(Method method, Object[] parameters, T loadBalanceable, ReturnType retVal) {
        LOGGER.debug((Object)"onReturn: do nothing !", new Object[0]);
        return BasicDecisionManager.doReturn(retVal);
    }

    public BasicDecisionManager<Void> onLookupException(T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnLookup(thr)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    public synchronized void setStrategy(ILBStrategy<T> lbStrategy) {
        this.lbStrategy = lbStrategy;
    }

    public String toString() {
        return "FirstAvailablePolicy - Load-balanceable selected is: " + this.nodeSelected + " - Strategy is: " + this.lbStrategy;
    }
}

