/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: LBClassWrapper.java 1579 2008-01-20 18:29:53Z eyindanga $
 * --------------------------------------------------------------------------
 */

/**
 *
 */
package org.ow2.carol.cmi.lb.data;

import java.io.Serializable;

/**
 * @author The new CMI team
 *
 */
public class LBClassWrapper implements Serializable{

    /**
     * Serial UID.
     */
    private static final long serialVersionUID = 1L;
    /**
     * The class name.
     */
    private String className = null;
    /**
     * LBpolicy or LBstrategy.
     */
    private String type = null;
    /**
     * Class content.
     */
    private Byte[] data;
    /**
     * LB informations contained in the <code>data</code> field are applied to this object.
     */
    private String objectName;

    /**
     * Default constructor.
     */
    public LBClassWrapper() {

    }

    /**
     * Constructor using fields.
     * @param className name of the class
     * @param type LBPolicy or LBStrategy
     * @param data byte code of the class
     * @param objectName LB infos concern this object.
     */
    public LBClassWrapper(final String className, final String type, final Byte[] data,
            final String objectName) {
        super();
        this.className = className;
        this.type = type;
        this.data = data;
        this.objectName = objectName;
    }
    /**Gets class name.
     * @return the class name
     */
    public String getClassName() {
        return className;
    }
    /**
     *Sets class name.
     * @param className class name.
     */
    public void setClassName(final String className) {
        this.className = className;
    }
    /**
     * Gets class type.
     * @return class type
     */
    public String getType() {
        return type;
    }
    /**
     * Sets class type.
     * @param type class type.
     */
    public void setType(final String type) {
        this.type = type;
    }
    /**
     * Gets Class byte code.
     * @return class byte code.
     */
    public Byte[] getData() {
        return data;
    }
    /**Sets Class byte code.
     * @param data byte code to set
     */
    public void setData(final Byte[] data) {
        this.data = data;
    }
    /**
     * Gets the name of the object.
     * @return name of the object.
     */
    public String getObjectName() {
        return objectName;
    }
    /**Sets object name.
     * @param objectName the object name.
     */
    public void setObjectName(final String objectName) {
        this.objectName = objectName;
    }

}
