/**
 * Copyright (C) 2007 - Bull S.A.S.
 *
 * CMI : Cluster Method Invocation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: BasicDecisionManager.java 1334 2007-10-19 14:44:36Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.cmi.lb.decision;

import net.jcip.annotations.Immutable;

/**
 * Encapsulates a decision and an eventually returned value.
 * @param <ReturnType> the type of the returned value (can be {@link Void})
 * @author The new CMI team
 */
@Immutable
public final class BasicDecisionManager<ReturnType> implements DecisionManager<ReturnType> {

    /**
     * Chosen Decision.
     */
    private final Decision decision;

    /**
     * Value associated with return decision.
     */
    private final ReturnType retVal;

    /**
     * Creates a return decision.
     * @param retVal the value to return
     */
    private BasicDecisionManager(final ReturnType retVal) {
        this.decision = Decision.RETURN;
        this.retVal = retVal;
    }

    /**
     * Creates a decision.
     * @param decision value of the decision
     */
    private BasicDecisionManager(final Decision decision) {
        this.decision = decision;
        this.retVal = null;
    }

    /**
     * Creates a retry decision.
     * @return retry
     */
    public static BasicDecisionManager<Void> doRetry() {
        return new BasicDecisionManager<Void>(Decision.RETRY);
    }

    /**
     * Creates a throw decision.
     * @return throw
     */
    public static BasicDecisionManager<Void> doThrow() {
        return new BasicDecisionManager<Void>(Decision.THROW);
    }

    /**
     * Creates a return decision.
     * @param retVal the value to return
     * @return return
     * @param <ReturnType> the type of the returned value (can be {@link Void})
     */
    public static <ReturnType> BasicDecisionManager<ReturnType> doReturn(final ReturnType retVal) {
        return new BasicDecisionManager<ReturnType>(retVal);
    }

    /**
     * @return the decision
     */
    public Decision getDecision() {
        return decision;
    }

    /**
     * @return the returned value
     */
    public ReturnType getRetVal() {
        return retVal;
    }
}
