/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007,2008 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: NoStrategy.java 1596 2008-01-27 17:50:35Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.lb.strategy;

import java.util.ArrayList;
import java.util.List;

import net.jcip.annotations.Immutable;

import org.ow2.carol.cmi.lb.LoadBalanceable;

/**
 * A strategy that does nothing.
 * @author The new CMI team
 * @param <T> The type of object that was load-balanced
 */
@Immutable
public class NoStrategy<T extends LoadBalanceable> implements ILBStrategy<T> {

    /**
     * Returns the same list of load-balanceables.
     * @param loadBalanceables a list of load-balanceables
     * @return the same list of load-balanceables
     */
    public List<T> choose(final List<T> loadBalanceables) {
        return new ArrayList<T>(loadBalanceables);
    }

    @Override
    public String toString() {
        return "NoStrategy";
    }

}
