/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.policy.AbsLBPolicy;
import org.ow2.carol.cmi.lb.policy.FirstAvailablePolicy;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class HASingletonPolicy
extends AbsLBPolicy<CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(HASingletonPolicy.class);
    private volatile List<String> serverRefs = new ArrayList<String>();
    private volatile ILBPolicy<CMIReference> lbPolicy;

    public HASingletonPolicy() {
        try {
            this.lbPolicy = (ILBPolicy)FirstAvailablePolicy.class.newInstance();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot instanciate FirstAvailable.class", new Object[]{e});
        }
    }

    @Override
    public synchronized CMIReference choose(List<CMIReference> cmiReferences) throws NoLoadBalanceableException {
        if (cmiReferences.size() == 0) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        for (String serverRef : this.serverRefs) {
            for (CMIReference cmiReference : cmiReferences) {
                if (!serverRef.equals(cmiReference.getServerRef().getProviderURL())) continue;
                LOGGER.debug((Object)"Found a singleton: {0}", new Object[]{serverRef});
                return cmiReference;
            }
        }
        return (CMIReference)this.lbPolicy.choose(cmiReferences);
    }

    @Override
    public void setLBStrategy(ILBStrategy<CMIReference> lbStrategy) {
        super.setLBStrategy(lbStrategy);
        this.lbPolicy.setLBStrategy(lbStrategy);
    }

    public List<String> getSingletons() {
        return this.serverRefs;
    }

    public synchronized void setSingletons(List<String> serverRefs) {
        this.serverRefs = serverRefs;
    }

    public synchronized void setSingleton(String serverRef) {
        this.serverRefs.add(0, serverRef);
    }

    public synchronized String getSingleton() {
        return this.serverRefs.get(0);
    }

    public String toString() {
        return "HASingletonPolicy[ServerRefs: " + this.serverRefs + " - master: " + this.serverRefs.get(0) + " - Rescue policy: " + this.lbPolicy + " - Rescue strategy: " + this.getLBStrategy() + "]";
    }
}

