/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.strategy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class LocalPreference
implements ILBStrategy<CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(LocalPreference.class);
    private final ClusterViewManager clusterViewManager;

    public LocalPreference(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public List<CMIReference> choose(List<CMIReference> cmiRefs) {
        ArrayList<CMIReference> localServers = new ArrayList<CMIReference>();
        for (CMIReference cmiRef : cmiRefs) {
            ServerRef serverRef = cmiRef.getServerRef();
            InetAddress inetAddress = serverRef.getInetAddress();
            try {
                if (!this.isLocal(inetAddress)) continue;
                localServers.add(cmiRef);
            }
            catch (SocketException e) {
                LOGGER.error((Object)"Cannot know if is local or not", new Object[]{e});
                throw new RuntimeException("Cannot know if is local or not", e);
            }
        }
        return localServers;
    }

    private boolean isLocal(InetAddress inetAddress) throws SocketException {
        return this.clusterViewManager instanceof ClientClusterViewManager ? NetworkInterface.getByInetAddress(inetAddress) != null : this.clusterViewManager instanceof ServerClusterViewManager && inetAddress.equals(((ServerClusterViewManager)this.clusterViewManager).getInetAddress());
    }

    public String toString() {
        return "LocalPreference";
    }
}

