/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.PropertyConfigurationException;
import org.ow2.carol.cmi.lb.data.LBPropertyData;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.util.LBPolicyFactoryException;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class LBPolicyFactory<T extends LoadBalanceable> {
    private static final Log LOGGER = LogFactory.getLog(LBPolicyFactory.class);
    private final ClusterViewManager clusterViewManager;
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, LBPropertyData>> propertyData = new ConcurrentHashMap();

    public LBPolicyFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public ILBPolicy<T> getLBPolicy(String objectName) throws LBPolicyFactoryException, ObjectNotFoundException {
        Class lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
        Map properties = this.clusterViewManager.getPropertiesForLBPolicy(objectName);
        Class lbStrategyClass = this.clusterViewManager.getLBStrategyClass(objectName);
        return this.getLBPolicy(lbPolicyClass, lbStrategyClass, properties);
    }

    public ILBPolicy<T> getLBPolicy(Class<? extends ILBPolicy> lbPolicyClass, Class<? extends ILBStrategy> lbStrategyClass, Map<String, ?> properties) throws LBPolicyFactoryException {
        ILBPolicy<T> lbPolicy = this.createLBPolicy(lbPolicyClass);
        try {
            LBPolicyFactory.findProperties(lbPolicy.getClass());
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Error while finding properties", new Object[]{e});
            throw new LBPolicyFactoryException("Error while finding properties", e);
        }
        if (properties != null) {
            try {
                this.setProperties(lbPolicy, properties);
            }
            catch (PropertyConfigurationException e) {
                LOGGER.error((Object)"Error while configuring the properties", new Object[]{e});
                throw new LBPolicyFactoryException("Error while configuring the properties", e);
            }
        }
        ILBStrategy<T> lbStrategy = this.createLBStrategy(lbStrategyClass);
        lbPolicy.setLBStrategy(lbStrategy);
        return lbPolicy;
    }

    private static void findProperties(Class<? extends ILBPolicy> lbPolicyClass) throws PropertyConfigurationException {
        String lbPolicyClassname = lbPolicyClass.getName();
        if (propertyData.containsKey(lbPolicyClassname)) {
            return;
        }
        ConcurrentHashMap<String, LBPropertyData> properties = new ConcurrentHashMap<String, LBPropertyData>();
        for (Method method : lbPolicyClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getLBStrategy")) continue;
            LBPropertyData lbPropertyData = new LBPropertyData(method, lbPolicyClass);
            properties.putIfAbsent(lbPropertyData.getLbPropertyName(), lbPropertyData);
        }
        propertyData.putIfAbsent(lbPolicyClassname, properties);
    }

    public ILBPolicy<T> createLBPolicy(Class<? extends ILBPolicy> lbPolicyClass) throws LBPolicyFactoryException {
        Constructor<?>[] constructors;
        ILBPolicy lbPolicy = null;
        for (Constructor<?> constructor : constructors = lbPolicyClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].equals(ClusterViewManager.class)) continue;
            try {
                lbPolicy = (ILBPolicy)constructor.newInstance(this.clusterViewManager);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the LB policy with the instance of ClusterViewManager", new Object[]{e});
                throw new LBPolicyFactoryException("Cannot construct the LB policy with the instance of ClusterViewManager", e);
            }
        }
        if (lbPolicy == null) {
            try {
                lbPolicy = lbPolicyClass.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the LB policy", new Object[]{e});
                throw new LBPolicyFactoryException("Cannot construct the LB policy", e);
            }
        }
        try {
            Method setter = lbPolicyClass.getMethod("setClusterViewManager", ClusterViewManager.class);
            setter.invoke((Object)lbPolicy, this.clusterViewManager);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot set the manager of cluster view", new Object[]{e});
        }
        return lbPolicy;
    }

    private void setProperties(ILBPolicy<T> lbPolicy, Map<String, ?> properties) throws PropertyConfigurationException {
        for (String propertyName : properties.keySet()) {
            Object propertyValue = properties.get(propertyName);
            this.setProperty(lbPolicy, propertyName, propertyValue);
        }
    }

    private void setProperty(ILBPolicy<T> lbPolicy, String propertyName, Object propertyValue) throws PropertyConfigurationException {
        Class<?> lbPolicyClass = lbPolicy.getClass();
        LBPropertyData lbPropertyData = propertyData.get(lbPolicyClass.getName()).get(propertyName);
        try {
            lbPropertyData.getSetter().invoke(lbPolicy, propertyValue);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot set the property for name {0} with {1}", new Object[]{propertyName, propertyValue, e});
            throw new PropertyConfigurationException("Cannot set the property for name " + propertyName + " with " + propertyValue, (Throwable)e);
        }
    }

    private ILBStrategy<T> createLBStrategy(Class<? extends ILBStrategy> lbStrategyClass) throws LBPolicyFactoryException {
        Constructor<?>[] constructors;
        ILBStrategy lbStrategy = null;
        for (Constructor<?> constructor : constructors = lbStrategyClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].equals(ClusterViewManager.class)) continue;
            try {
                lbStrategy = (ILBStrategy)constructor.newInstance(this.clusterViewManager);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the LB strategy with the instance of ClusterViewManager", new Object[]{e});
                throw new LBPolicyFactoryException("Cannot construct the LB strategy with the instance of ClusterViewManager", e);
            }
        }
        if (lbStrategy == null) {
            try {
                lbStrategy = lbStrategyClass.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the LB strategy with the default constructor", new Object[]{e});
                throw new LBPolicyFactoryException("Cannot construct the LB strategy with the default constructor", e);
            }
        }
        return lbStrategy;
    }

    public static Map<String, Object> getProperties(ILBPolicy<?> lbPolicy) throws PropertyConfigurationException {
        Class<?> lbPolicyClass = lbPolicy.getClass();
        LBPolicyFactory.findProperties(lbPolicyClass);
        Map lbPropertyData = propertyData.get(lbPolicyClass.getName());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propertyName : lbPropertyData.keySet()) {
            Object propertyValue = LBPolicyFactory.getProperty(lbPolicy, propertyName);
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    public static Object getProperty(ILBPolicy<?> lbPolicy, String propertyName) throws PropertyConfigurationException {
        Class<?> lbPolicyClass = lbPolicy.getClass();
        LBPolicyFactory.findProperties(lbPolicyClass);
        Map lbPropertyData = propertyData.get(lbPolicyClass.getName());
        LBPropertyData property = (LBPropertyData)lbPropertyData.get(propertyName);
        try {
            return property.getGetter().invoke(lbPolicy, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot invoke the getter for property {0}", new Object[]{propertyName, e});
            return null;
        }
    }

    public static Type getPropertyRawType(Class<? extends ILBPolicy> lbPolicyClass, String propertyName) throws PropertyConfigurationException {
        Type propertyType = LBPolicyFactory.getPropertyType(lbPolicyClass, propertyName);
        if (propertyType instanceof ParameterizedType) {
            return ((ParameterizedType)propertyType).getRawType();
        }
        return propertyType;
    }

    public static Type getPropertyType(Class<? extends ILBPolicy> lbPolicyClass, String propertyName) throws PropertyConfigurationException {
        LBPolicyFactory.findProperties(lbPolicyClass);
        return propertyData.get(lbPolicyClass.getName()).get(propertyName).getLbPropertyType();
    }

    public static Map<String, LBPropertyData> getPropertyData(Class<? extends ILBPolicy> lbPolicyClass) throws PropertyConfigurationException {
        LBPolicyFactory.findProperties(lbPolicyClass);
        return propertyData.get(lbPolicyClass.getName());
    }

    public static Object convertString(Class<? extends ILBPolicy> lbPolicyClass, String lbPropertyName, String svalue) throws PropertyConfigurationException {
        Type propertyType = LBPolicyFactory.getPropertyType(lbPolicyClass, lbPropertyName);
        return LBPolicyFactory.convertString(propertyType, svalue);
    }

    public static Object convertString(Type propertyType, String svalue) throws PropertyConfigurationException {
        Class<?> propertyValue;
        if (propertyType instanceof ParameterizedType) {
            LOGGER.error((Object)"Cannot convert a parameterized type.", new Object[0]);
            throw new PropertyConfigurationException("Cannot convert a parameterized type");
        }
        Class klass = (Class)propertyType;
        if (klass.equals(String.class)) {
            propertyValue = svalue;
        } else if (klass.equals(Boolean.TYPE)) {
            propertyValue = Boolean.valueOf(svalue);
        } else if (klass.equals(Byte.TYPE)) {
            propertyValue = Byte.valueOf(svalue);
        } else if (klass.equals(Integer.TYPE)) {
            propertyValue = Integer.valueOf(svalue);
        } else if (klass.equals(Long.TYPE)) {
            propertyValue = Long.valueOf(svalue);
        } else if (klass.equals(Float.TYPE)) {
            propertyValue = Float.valueOf(svalue);
        } else if (klass.equals(Double.TYPE)) {
            propertyValue = Double.valueOf(svalue);
        } else if (klass.equals(URL.class)) {
            try {
                propertyValue = new URL(svalue);
            }
            catch (MalformedURLException e) {
                throw new PropertyConfigurationException("Cannot convert the string " + svalue + " to an URL", (Throwable)e);
            }
        } else if (klass.equals(File.class)) {
            propertyValue = new File(svalue);
        } else if (klass.equals(Class.class)) {
            try {
                propertyValue = Class.forName(svalue);
            }
            catch (ClassNotFoundException e) {
                throw new PropertyConfigurationException("Cannot convert the string " + svalue + " to a class", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)"Type of field not supported: {0}", new Object[]{klass.getName()});
            throw new PropertyConfigurationException("Type of field not supported: " + klass.getName());
        }
        return propertyValue;
    }

    public static List<?> convertStrings(Class<? extends ILBPolicy> lbPolicyClass, String lbPropertyName, List<String> slist) throws PropertyConfigurationException {
        Type parameterizedType = LBPolicyFactory.getPropertyType(lbPolicyClass, lbPropertyName);
        if (!(parameterizedType instanceof ParameterizedType)) {
            LOGGER.error((Object)"{0} is not a parameterized type: cannot convert the elements of this collection", new Object[]{parameterizedType});
            throw new PropertyConfigurationException(parameterizedType + "is not a parameterized type: cannot convert the elements of this collection");
        }
        Type propertyType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
        ArrayList<Object> values = new ArrayList<Object>();
        for (String svalue : slist) {
            values.add(LBPolicyFactory.convertString(propertyType, svalue));
        }
        return values;
    }
}

