/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.data;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class LBPolicyData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7135811410484151772L;
    private volatile String policyType;
    private volatile ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private volatile long dateOfProperties;
    private volatile String strategyType;

    public LBPolicyData(String policyType, String strategyType, Map<String, Object> properties) {
        this.policyType = policyType;
        this.strategyType = strategyType;
        if (properties == null || properties.isEmpty()) {
            this.dateOfProperties = 0L;
        } else {
            Date date = new Date();
            this.dateOfProperties = date.getTime();
            this.properties.putAll(properties);
        }
    }

    public LBPolicyData(String policyType, String strategyType, Map<String, Object> properties, long dateOfProperties) {
        this.policyType = policyType;
        this.strategyType = strategyType;
        this.dateOfProperties = dateOfProperties;
        if (dateOfProperties != 0L) {
            this.properties.putAll(properties);
        }
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String lbPolicyType) {
        this.policyType = lbPolicyType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperties(Map<String, Object> properties) {
        properties.clear();
        properties.putAll(properties);
        Date date = new Date();
        this.dateOfProperties = date.getTime();
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
        Date date = new Date();
        this.dateOfProperties = date.getTime();
    }

    public long getDateOfProperties() {
        return this.dateOfProperties;
    }

    public String getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(String lbStrategyType) {
        this.strategyType = lbStrategyType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LBPolicyData)) {
            return false;
        }
        LBPolicyData lbPolicyData = (LBPolicyData)object;
        return this.policyType.equals(lbPolicyData.policyType) && this.strategyType.equals(lbPolicyData.strategyType) && this.properties.equals(lbPolicyData.properties) && this.dateOfProperties == lbPolicyData.dateOfProperties;
    }

    public int hashCode() {
        return (int)((long)(this.policyType.hashCode() + this.strategyType.hashCode() + this.properties.hashCode()) + this.dateOfProperties);
    }

    public String toString() {
        return "[policyType=" + this.policyType + ",strategyType=" + this.strategyType + ",properties=" + this.properties + ",dateOfProperties=" + this.dateOfProperties + "]";
    }

    public LBPolicyData clone() throws CloneNotSupportedException {
        LBPolicyData lbPolicyData = (LBPolicyData)super.clone();
        lbPolicyData.properties = new ConcurrentHashMap<String, Object>(this.properties);
        return lbPolicyData;
    }
}

