/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.policy.AbsLBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class RandomPolicy<T extends LoadBalanceable>
extends AbsLBPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(RandomPolicy.class);
    private final Random random = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List cmiRefsWithStrategy;
        if (loadBalanceables.size() == 0) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        ILBStrategy lbStrategy = this.getLBStrategy();
        if (lbStrategy != null) {
            cmiRefsWithStrategy = lbStrategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        int index = this.random.nextInt(cmiRefsWithStrategy.size());
        return (T)((LoadBalanceable)cmiRefsWithStrategy.get(index));
    }

    public String toString() {
        return "RandomPolicy[LB strategy: " + this.getLBStrategy() + "]";
    }
}

