/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.policy.AbsLBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.strategy.NoStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class RoundRobinPolicy<T extends LoadBalanceable>
extends AbsLBPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(RoundRobinPolicy.class);
    private static final int INITIAL_VALUE = -1;
    private int pointer = -1;
    private final Random rand = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List cmiRefsWithStrategy;
        if (loadBalanceables == null) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        ILBStrategy lbStrategy = this.getLBStrategy();
        if (lbStrategy != null) {
            cmiRefsWithStrategy = lbStrategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        int size = cmiRefsWithStrategy.size();
        if (this.pointer == -1) {
            this.pointer = lbStrategy != null && !(lbStrategy instanceof NoStrategy) ? 0 : this.rand.nextInt(size);
        } else {
            if (this.pointer >= size) {
                this.pointer = -1;
            }
            this.pointer = (this.pointer + 1) % size;
        }
        return (T)((LoadBalanceable)cmiRefsWithStrategy.get(this.pointer));
    }

    public String toString() {
        return "RoundRobinPolicy[pointer: " + this.pointer + " - LB strategy: " + this.getLBStrategy() + "]";
    }
}

