/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.strategy.LoadFactorComparator;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFactorWeight<T extends LoadBalanceable>
implements ILBStrategy<T> {
    private static final Log LOGGER = LogFactory.getLog(LoadFactorWeight.class);
    private final LoadFactorComparator<T> comparator;
    private final ClusterViewManager clusterViewManager;

    public LoadFactorWeight(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
        this.comparator = new LoadFactorComparator(clusterViewManager);
    }

    public List<T> choose(List<T> loadBalanceables) {
        int maxLoad;
        ArrayList<LoadBalanceable> weightedList = new ArrayList<LoadBalanceable>();
        ArrayList<T> orderedLoadBalanceables = new ArrayList<T>(loadBalanceables);
        Collections.sort(orderedLoadBalanceables, this.comparator);
        ServerRef maxLoaded = ((LoadBalanceable)orderedLoadBalanceables.get(orderedLoadBalanceables.size() - 1)).getServerRef();
        try {
            maxLoad = this.clusterViewManager.getLoadFactor(maxLoaded);
        }
        catch (ServerNotFoundException e) {
            LOGGER.error((Object)"Cannot get the load factor for {0}. The strategy cannot be applied.", new Object[]{maxLoaded, e});
            return loadBalanceables;
        }
        LOGGER.debug((Object)"The max load factor {0} is for {1}", new Object[]{maxLoad, maxLoaded});
        for (LoadBalanceable loadBalanceable : orderedLoadBalanceables) {
            int weight;
            try {
                weight = 100 - Math.round(this.clusterViewManager.getLoadFactor(loadBalanceable.getServerRef()) / maxLoad * 100);
            }
            catch (ServerNotFoundException e) {
                LOGGER.error((Object)"Cannot get the load factor for {0}. The strategy cannot be applied.", new Object[]{loadBalanceable, e});
                return loadBalanceables;
            }
            for (int i = 0; i < weight; ++i) {
                weightedList.add(loadBalanceable);
            }
        }
        return weightedList;
    }
}

