/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.rmi;

import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.ow2.carol.cmi.config.JNDIConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultCMIPRODelegate
implements PortableRemoteObjectDelegate {
    private static Log logger = LogFactory.getLog(DefaultCMIPRODelegate.class);

    public void connect(Remote target, Remote source) throws RemoteException {
        if (target == null || source == null) {
            logger.error((java.lang.Object)"invalid argument", new java.lang.Object[0]);
            throw new NullPointerException("invalid argument");
        }
        String protocol = JNDIConfig.getProtocol();
        if (protocol.equals("iiop")) {
            ORB orb = null;
            try {
                if (StubAdapter.isStub((java.lang.Object)source)) {
                    orb = StubAdapter.getORB((java.lang.Object)source);
                } else {
                    Tie tie = Util.getTie((Remote)source);
                    if (tie != null) {
                        orb = tie.orb();
                    }
                }
            }
            catch (SystemException e) {
                logger.error((java.lang.Object)"'source' object not connected", new java.lang.Object[]{e});
                throw new RemoteException("'source' object not connected", e);
            }
            boolean targetIsIIOP = false;
            Tie targetTie = null;
            if (StubAdapter.isStub((java.lang.Object)target)) {
                targetIsIIOP = true;
            } else {
                targetTie = Util.getTie((Remote)target);
                if (targetTie != null) {
                    targetIsIIOP = true;
                }
            }
            if (!targetIsIIOP) {
                if (orb != null) {
                    logger.error((java.lang.Object)"'source' object exported to IIOP, 'target' is JRMP", new java.lang.Object[0]);
                    throw new RemoteException("'source' object exported to IIOP, 'target' is JRMP");
                }
            } else {
                if (orb == null) {
                    logger.error((java.lang.Object)"'source' object is JRMP, 'target' is IIOP", new java.lang.Object[0]);
                    throw new RemoteException("'source' object is JRMP, 'target' is IIOP");
                }
                try {
                    if (targetTie != null) {
                        try {
                            ORB existingOrb = targetTie.orb();
                            if (existingOrb == orb) {
                                return;
                            }
                            logger.error((java.lang.Object)"'target' object was already connected", new java.lang.Object[0]);
                            throw new RemoteException("'target' object was already connected");
                        }
                        catch (SystemException e) {
                            logger.error((java.lang.Object)e, new java.lang.Object[0]);
                            targetTie.orb(orb);
                        }
                    } else {
                        StubAdapter.connect((java.lang.Object)target, (ORB)orb);
                    }
                }
                catch (SystemException e) {
                    logger.error((java.lang.Object)"'target' object was already connected", new java.lang.Object[]{e});
                    throw new RemoteException("'target' object was already connected", e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void exportObject(Remote obj) throws RemoteException {
        if (obj == null) {
            logger.error((java.lang.Object)"invalid argument", new java.lang.Object[0]);
            throw new NullPointerException("invalid argument");
        }
        String protocol = JNDIConfig.getProtocol();
        if (protocol.equals("iiop")) {
            logger.debug((java.lang.Object)"Exporting to iiop...", new java.lang.Object[0]);
            if (Util.getTie((Remote)obj) != null) {
                logger.error((java.lang.Object)"{0} already exported", new java.lang.Object[]{obj.getClass().getName()});
                throw new ExportException(obj.getClass().getName() + " already exported");
            }
            Tie theTie = Utility.loadTie((Remote)obj);
            if (theTie != null) {
                Util.registerTarget((Tie)theTie, (Remote)obj);
                return;
            }
            logger.error((java.lang.Object)"Tie not found", new java.lang.Object[0]);
            throw new ExportException("Tie not found");
        }
        if (protocol.equals("jrmp")) {
            logger.debug((java.lang.Object)"Exporting to jrmp...", new java.lang.Object[0]);
            UnicastRemoteObject.exportObject(obj);
            return;
        }
        logger.error((java.lang.Object)"{0} is not a supported protocol. Use jrmp, iiop or irmi.", new java.lang.Object[]{protocol});
        throw new ExportException(protocol + " is not a supported protocol. Use jrmp, iiop or irmi.");
    }

    public java.lang.Object narrow(java.lang.Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowFrom == null) {
            return null;
        }
        if (narrowTo == null) {
            logger.error((java.lang.Object)"invalid argument", new java.lang.Object[0]);
            throw new NullPointerException("invalid argument");
        }
        try {
            if (narrowTo.isAssignableFrom(narrowFrom.getClass())) {
                return narrowFrom;
            }
            if (narrowTo.isInterface() && narrowTo != Serializable.class && narrowTo != Externalizable.class) {
                Object narrowObj = (Object)narrowFrom;
                String id = RepositoryId.createForAnyType((Class)narrowTo);
                if (narrowObj._is_a(id)) {
                    return Utility.loadStub((Object)narrowObj, (Class)narrowTo);
                }
                logger.error((java.lang.Object)"Object is not of remote type {0}", new java.lang.Object[]{narrowTo.getName()});
                throw new ClassCastException("Object is not of remote type " + narrowTo.getName());
            }
            logger.error((java.lang.Object)"Class {0} is not a valid remote interface", new java.lang.Object[]{narrowTo.getName()});
            throw new ClassCastException("Class " + narrowTo.getName() + " is not a valid remote interface");
        }
        catch (Exception error) {
            logger.error((java.lang.Object)error, new java.lang.Object[0]);
            ClassCastException cce = new ClassCastException();
            cce.initCause(error);
            throw cce;
        }
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        Remote result = null;
        if (obj == null) {
            logger.error((java.lang.Object)"invalid argument", new java.lang.Object[0]);
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub((java.lang.Object)obj)) {
            return obj;
        }
        if (obj instanceof RemoteStub) {
            return obj;
        }
        String protocol = JNDIConfig.getProtocol();
        if (protocol.equals("iiop")) {
            Tie theTie = Util.getTie((Remote)obj);
            if (theTie != null) {
                result = Utility.loadStub((Tie)theTie, null, null, (boolean)true);
            }
        } else if (protocol.equals("jrmp")) {
            result = RemoteObject.toStub(obj);
        } else {
            logger.error((java.lang.Object)"Unknown object for {0}", new java.lang.Object[]{protocol});
            throw new NoSuchObjectException("Unknown object for " + protocol);
        }
        if (result == null) {
            logger.error((java.lang.Object)"Object not exported.", new java.lang.Object[0]);
            throw new NoSuchObjectException("object not exported");
        }
        return result;
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            logger.error((java.lang.Object)"invalid argument", new java.lang.Object[0]);
            throw new NullPointerException("invalid argument");
        }
        if (StubAdapter.isStub((java.lang.Object)obj) || obj instanceof RemoteStub) {
            logger.error((java.lang.Object)"Can only unexport a server object.", new java.lang.Object[0]);
            throw new NoSuchObjectException("Can only unexport a server object.");
        }
        String protocol = JNDIConfig.getProtocol();
        if (protocol.equals("iiop")) {
            logger.debug((java.lang.Object)"Unexporting for iiop...", new java.lang.Object[0]);
            Tie theTie = Util.getTie((Remote)obj);
            if (theTie != null) {
                Util.unexportObject((Remote)obj);
            } else if (Utility.loadTie((Remote)obj) != null) {
                logger.error((java.lang.Object)"Object not exported.", new java.lang.Object[0]);
                throw new NoSuchObjectException("Object not exported.");
            }
        } else if (protocol.equals("jrmp")) {
            logger.debug((java.lang.Object)"Unexporting for jrmp...", new java.lang.Object[0]);
            UnicastRemoteObject.unexportObject(obj, true);
        } else {
            logger.error((java.lang.Object)"{0} is not a supported protocol. Use jrmp, iiop or irmi.", new java.lang.Object[]{protocol});
            throw new NoSuchObjectException(protocol + " is not a supported protocol. Use jrmp, iiop or irmi.");
        }
    }
}

