/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.rpc;

import java.lang.reflect.Method;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.carol.cmi.rpc.POJOInvocationHandlerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class POJOInvocationHandler
extends CMIInvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(POJOInvocationHandler.class);
    private final ClassLoader classLoader;
    private final Class<?> itf;

    public POJOInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<?> itf) {
        super(clusterViewManager, objectName, protocolName, false);
        this.classLoader = classLoader;
        this.itf = itf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws POJOInvocationHandlerException, Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            Object object = super.invokeRemoteMethod(proxy, method, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected String proxyToString(Object proxy) {
        return "POJOProxy[" + super.proxyToString(proxy) + ", itf:" + this.itf.getName() + "]";
    }
}

