/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id:CMIInvocationHandlerException.java 1077 2007-07-08 07:33:35Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.rpc;


/**
 * Exception thrown when a server cannot be chosen when invoking a method of a clustered object.
 * @author The new CMI team
 * @see POJOInvocationHandler
 */
public final class POJOInvocationHandlerException extends CMIInvocationHandlerException {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 3553877797842695479L;

    public POJOInvocationHandlerException(final String msg) {
        super(msg);
    }

    public POJOInvocationHandlerException(final String msg, final Throwable cause) {
        super(msg, cause);
    }

}
