/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import javax.ejb.EJBHome;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.pool.EJBObjectFactory;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBHomeInvocationHandler;
import org.ow2.carol.cmi.ejb2_1.rpc.ha.HAEJBHomeInvocationHandler;
import org.ow2.carol.cmi.pool.StubOrProxyFactory;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.carol.cmi.rpc.CMIProxyFactoryException;
import org.ow2.carol.cmi.rpc.POJOInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

@ThreadSafe
public final class CMIProxyFactory {
    private static final Log LOGGER = LogFactory.getLog(CMIProxyFactory.class);

    private CMIProxyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMIProxy newCMIProxy(ClusterViewManager clusterViewManager, String objectName, String protocolName) throws CMIProxyFactoryException, ObjectNotFoundException {
        POJOInvocationHandler invocationHandler;
        ClusterViewManager clusterViewManager2;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class itfClass = clusterViewManager.getInterface(objectName);
        if (!clusterViewManager.isReplicated(objectName)) {
            if (Arrays.asList(itfClass.getInterfaces()).contains(EJBHome.class)) {
                LOGGER.debug((Object)"Object with name {0} is a stateless ejb2", new Object[0]);
                clusterViewManager2 = clusterViewManager;
                synchronized (clusterViewManager2) {
                    if (clusterViewManager.getPool(objectName) == null) {
                        LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBObject", new Object[]{objectName});
                        clusterViewManager.setPool(objectName, (Pool)new JPool((PoolFactory)new EJBObjectFactory(clusterViewManager)));
                    }
                }
                invocationHandler = new EJBHomeInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
            } else {
                clusterViewManager2 = clusterViewManager;
                synchronized (clusterViewManager2) {
                    if (clusterViewManager.getPool(objectName) == null) {
                        LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its mandatories", new Object[]{objectName});
                        clusterViewManager.setPool(objectName, (Pool)new JPool((PoolFactory)new StubOrProxyFactory(clusterViewManager)));
                    }
                }
                invocationHandler = new POJOInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
            }
        } else if (Arrays.asList(itfClass.getInterfaces()).contains(EJBHome.class)) {
            LOGGER.debug((Object)"Object with name {0} is a statefull ejb2 or an entity bean: the HA module will be used", new Object[0]);
            clusterViewManager2 = clusterViewManager;
            synchronized (clusterViewManager2) {
                if (clusterViewManager.getPool(objectName) == null) {
                    LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBHome", new Object[]{objectName});
                    clusterViewManager.setPool(objectName, (Pool)new JPool((PoolFactory)new StubOrProxyFactory(clusterViewManager)));
                }
            }
            invocationHandler = new HAEJBHomeInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
        } else {
            throw new UnsupportedOperationException("TODO !");
        }
        Object cmiProxy = Proxy.newProxyInstance(classLoader, new Class[]{itfClass, CMIProxy.class}, (InvocationHandler)((Object)invocationHandler));
        return (CMIProxy)cmiProxy;
    }
}

