
/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: FactoryNameAnswer.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

import org.ow2.carol.cmi.smart.api.Message;
import org.ow2.carol.cmi.smart.api.Operations;

/**
 * Server sends the factory name to the client.
 * @author The new CMI team
 */
public class FactoryNameAnswer implements Message {

    /**
     * The factory name.
     */
    private String factoryName = null;

    /**
     * Create a new answer with the given buffer for the wrapped factory name.
     *
     * @param buffer containing the data to extract.
     */
    public FactoryNameAnswer(final ByteBuffer buffer) {
//        Charset charset = Charset.forName("UTF-8");
      Charset charset = Charset.forName("us-ascii");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer urlsBuffer = decoder.decode(buffer);
            factoryName = urlsBuffer.toString();
        } catch (CharacterCodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * Create a new answer with the given wrapped factory name.
     * @param factoryName the given wrapped factory name.
     */
    public FactoryNameAnswer(final String factoryName) {
        this.factoryName = factoryName;
    }

    /**
     * Gets a message to send.
     * @return the bytebuffer to send
     */
    public ByteBuffer getMessage() {
        ByteBuffer message = getMessageContent();

        // compute length
        int length = HEADER_SIZE;
        if (message != null) {
            length += message.capacity();
        }

        // Create ByteBuffer
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);

        // Append header
        byteBuffer.put(getOperationCode());

        if(message != null){
        byteBuffer.putInt(message.capacity());
        }

        // append inner message (go to position 0 first)
        if(message != null){
        message.position(0);
        byteBuffer.put(message);
        }

        // reset our position
        byteBuffer.position(0);

        // return buffer
        return byteBuffer;
    }

    /**
     * Gets the content of this message (only this part, not the header).
     * @return the content of this message.
     */
    public ByteBuffer getMessageContent() {
        ByteBuffer factoryNameBuffer = encode(factoryName);
        return factoryNameBuffer;
    }

    /**
     * Gets the Operation Code of this answer.
     * @return the operation code.
     */
    public byte getOperationCode() {
        return Operations.FACTORY_NAME_ANSWER;
    }

    /**
     * Get the wrapped factory name.
     * @return the wrapped factory name.
     */
    public String getFactoryName() {
        return factoryName;
    }

    /**
     * Encode the given string into a bytebuffer.
     * @param str the given string
     * @return a bytebuffer with UTF-8 encoded string
     */
    protected ByteBuffer encode(final String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);

        buffer.put(bytes);

        return buffer;

    }

}
