
/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: FactoryNameRequest.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

import org.ow2.carol.cmi.smart.api.Message;
import org.ow2.carol.cmi.smart.api.Operations;

/**
 * Client asks the factory name to the server.
 *
 * @author The new CMI team
 */
public class FactoryNameRequest implements Message {

    /**
     * The protocol attached with the factory name.
     */
    private String protocol = null;

    /**
     * Builds a new message with the given name.
     *
     * @param protocol the given protocol
     */
    public FactoryNameRequest(final String protocol) {
        this.protocol = protocol;
    }

    /**
     * Gets a message to send.
     *
     * @return the bytebuffer to send
     */
    public ByteBuffer getMessage() {
        ByteBuffer message = getMessageContent();

        // compute length
        int length = HEADER_SIZE;
        if (message != null) {
            length += message.capacity();
        }

        // Create ByteBuffer
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);

        // Append header
        byteBuffer.put(getOperationCode());
        byteBuffer.putInt(message.capacity());

        // append inner message (go to position 0 first)
        message.position(0);
        byteBuffer.put(message);

        // reset our position
        byteBuffer.position(0);

        // return buffer
        return byteBuffer;
    }

    /**
     * Gets the content of this message (only this part, not the header).
     *
     * @return the content of this message.
     */
    public ByteBuffer getMessageContent() {
        ByteBuffer protocolBuffer = encode(protocol);
        return protocolBuffer;
    }

    /**
     * Encode the given string into a bytebuffer.
     *
     * @param str
     *            the given string
     * @return a bytebuffer with UTF-8 encoded string
     */
    protected ByteBuffer encode(final String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);

        buffer.put(bytes);

        return buffer;

    }

    /**
     * Gets the Operation Code of this answer.
     * @return the operation code.
     */
    public byte getOperationCode() {
        return Operations.FACTORY_NAME_REQUEST;
    }

}
