/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.carol.cmi.smart.api.Message;
import org.ow2.carol.cmi.smart.message.ClassAnswer;
import org.ow2.carol.cmi.smart.message.ClassRequest;
import org.ow2.carol.cmi.smart.message.FactoryNameAnswer;
import org.ow2.carol.cmi.smart.message.FactoryNameRequest;
import org.ow2.carol.cmi.smart.message.ProviderURLsAnswer;
import org.ow2.carol.cmi.smart.message.ProviderURLsRequest;
import org.ow2.carol.cmi.smart.message.ResourceAnswer;
import org.ow2.carol.cmi.smart.message.ResourceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartClassLoader
extends URLClassLoader {
    private static Logger logger = Logger.getLogger(SmartClassLoader.class.getName());
    private InetSocketAddress socketAddress = null;
    private static final int DEFAULT_BUFFER_SIZE = 3000;
    private static int nbClasses = 0;
    private static int nbResources = 0;
    private static long nbBytes = 0L;
    private static long timeToDownload = 0L;

    public SmartClassLoader(String host, int port) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.socketAddress = new InetSocketAddress(host, port);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getProviderURLs(String protocol) {
        List<String> providerURLs = null;
        SocketChannel channel = null;
        if (protocol != null) {
            try {
                long tStart = System.currentTimeMillis();
                channel = this.getChannel();
                ByteBuffer answerBuffer = this.sendRequest(new ProviderURLsRequest(protocol), channel);
                byte opCode = this.getOpCode(answerBuffer, channel);
                timeToDownload += System.currentTimeMillis() - tStart;
                switch (opCode) {
                    case 6: {
                        ProviderURLsAnswer providerURLAnswer = new ProviderURLsAnswer(answerBuffer);
                        providerURLs = providerURLAnswer.getProviderURLs();
                        return providerURLs;
                    }
                    default: {
                        throw new IllegalStateException("Invalid opCode '" + opCode + "' received");
                    }
                }
            }
            finally {
                this.cleanChannel(channel);
            }
        }
        logger.log(Level.INFO, "The protocol of client is missing!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getWrappedFactoryName(String protocol) {
        String factoryName = null;
        SocketChannel channel = null;
        if (protocol != null) {
            try {
                channel = this.getChannel();
                ByteBuffer answerBuffer = this.sendRequest(new FactoryNameRequest(protocol), channel);
                byte opCode = this.getOpCode(answerBuffer, channel);
                switch (opCode) {
                    case 8: {
                        FactoryNameAnswer factoryNameAnswer = new FactoryNameAnswer(answerBuffer);
                        factoryName = factoryNameAnswer.getFactoryName();
                        return factoryName;
                    }
                    default: {
                        throw new IllegalStateException("Invalid opCode '" + opCode + "' received");
                    }
                }
            }
            finally {
                this.cleanChannel(channel);
            }
        }
        logger.log(Level.INFO, "The protocol of client is missing!");
        return null;
    }

    private SocketChannel getChannel() {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot open a channel", e);
        }
        try {
            channel.connect(this.socketAddress);
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot connect the channel", e);
        }
        return channel;
    }

    private void cleanChannel(SocketChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Cannot close the given channel", e);
            }
        }
    }

    public ByteBuffer sendRequest(Message message, SocketChannel channel) {
        try {
            channel.write(message.getMessage());
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot send the given message '" + message + "'.", e);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(3000);
        ByteBuffer completeBuffer = null;
        try {
            int length = 0;
            boolean finished = false;
            while (channel.read(buffer) != -1 && !finished) {
                if (buffer.position() >= 5 && completeBuffer == null) {
                    length = buffer.getInt(1);
                    completeBuffer = ByteBuffer.allocate(5 + length + 3000);
                }
                buffer.flip();
                completeBuffer.put(buffer);
                buffer.clear();
                if (completeBuffer.position() < 5 + length) continue;
                completeBuffer.limit(5 + length);
                completeBuffer.position(5);
                finished = true;
                break;
            }
        }
        catch (Exception e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot read the answer from the server.", e);
        }
        return completeBuffer;
    }

    private byte getOpCode(ByteBuffer buffer, SocketChannel channel) {
        byte opCode = buffer.get(0);
        int length = buffer.getInt(1);
        if (length < 0) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Invalid length for client '" + length + "'.");
        }
        return opCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        logger.log(Level.INFO, "Try to find the class \"" + name + "\"" + "...");
        SocketChannel channel = null;
        try {
            long tStart = System.currentTimeMillis();
            channel = this.getChannel();
            ByteBuffer answerBuffer = this.sendRequest(new ClassRequest(name), channel);
            byte opCode = this.getOpCode(answerBuffer, channel);
            timeToDownload += System.currentTimeMillis() - tStart;
            switch (opCode) {
                case 2: {
                    ClassAnswer classAnswer = new ClassAnswer(answerBuffer);
                    try {
                        clazz = this.loadClass(name, classAnswer.getByteCode());
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("Cannot find the class", e);
                    }
                    ++nbClasses;
                    nbBytes += (long)classAnswer.getByteCode().length;
                    return clazz;
                }
                case 10: {
                    throw new ClassNotFoundException("The class '" + name + "' was not found on the remote side");
                }
                default: {
                    throw new ClassNotFoundException("Invalid opCode '" + opCode + "' received");
                }
            }
        }
        finally {
            this.cleanChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String className, byte[] bytecode) throws IOException {
        Class clazz = null;
        try {
            SmartClassLoader loader = this;
            Class<?> cls = Class.forName("java.lang.ClassLoader");
            Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            try {
                Object[] args = new Object[]{className, bytecode, new Integer(0), new Integer(bytecode.length)};
                clazz = (Class)method.invoke((Object)loader, args);
            }
            finally {
                method.setAccessible(false);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Cannt define class with name '" + className + "'.");
            ioe.initCause(e);
            throw ioe;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized URL findResource(String name) {
        URL url = null;
        if (name.startsWith("META-INF")) {
            return null;
        }
        SocketChannel channel = null;
        try {
            long tStart = System.currentTimeMillis();
            channel = this.getChannel();
            ByteBuffer answerBuffer = this.sendRequest(new ResourceRequest(name), channel);
            byte opCode = this.getOpCode(answerBuffer, channel);
            timeToDownload += System.currentTimeMillis() - tStart;
            switch (opCode) {
                case 4: {
                    ResourceAnswer resourceAnswer = new ResourceAnswer(answerBuffer);
                    String resourceName = resourceAnswer.getResourceName();
                    byte[] bytes = resourceAnswer.getBytes();
                    ++nbResources;
                    nbBytes += (long)resourceAnswer.getBytes().length;
                    File fConfDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "cmi-smart");
                    if (!fConfDir.exists()) {
                        fConfDir.mkdir();
                    }
                    String[] tokens = resourceName.split("/");
                    StringBuilder sb = new StringBuilder();
                    for (String token : tokens) {
                        if (sb.length() > 0) {
                            sb.append(File.separator);
                        }
                        sb.append(token);
                    }
                    File urlFile = new File(fConfDir, sb.toString());
                    if (!urlFile.getParentFile().exists()) {
                        urlFile.getParentFile().mkdir();
                    }
                    FileOutputStream fos = new FileOutputStream(urlFile);
                    fos.write(bytes);
                    fos.close();
                    url = urlFile.toURI().toURL();
                    return url;
                }
                case 9: {
                    url = null;
                    return url;
                }
                default: {
                    throw new IllegalStateException("Invalid opCode '" + opCode + "' received");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot handle : findResource '" + name + "'", e);
            return url;
        }
        finally {
            this.cleanChannel(channel);
        }
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            System.out.println("Downloaded '" + nbClasses + "' classes, '" + nbResources + "' resources for a total of '" + nbBytes + "' bytes and it took '" + timeToDownload + "' ms.");
        }
    }
}

