/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.ow2.carol.cmi.smart.api.Message;

public class ClassAnswer
implements Message {
    private String className = null;
    private byte[] bytes = null;

    public ClassAnswer(String className, byte[] bytes) {
        this.className = className;
        this.bytes = bytes;
    }

    public ClassAnswer(ByteBuffer dataBuffer) {
        int nameLength = dataBuffer.getInt();
        ByteBuffer nameBuffer = ByteBuffer.allocate(nameLength);
        for (int l = 0; l < nameLength; ++l) {
            byte b = dataBuffer.get();
            nameBuffer.put(b);
        }
        nameBuffer.position(0);
        this.className = this.decode(nameBuffer);
        this.bytes = new byte[dataBuffer.limit() - dataBuffer.position()];
        int k = 0;
        for (int i = dataBuffer.position(); i < dataBuffer.limit(); ++i) {
            this.bytes[k++] = dataBuffer.get(i);
        }
    }

    public ByteBuffer getMessage() {
        ByteBuffer message = this.getMessageContent();
        int length = 5;
        if (message != null) {
            length += message.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(this.getOperationCode());
        if (message != null) {
            byteBuffer.putInt(message.capacity());
            message.position(0);
            byteBuffer.put(message);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public byte getOperationCode() {
        return 2;
    }

    public ByteBuffer getMessageContent() {
        ByteBuffer nameBuffer = this.encode(this.className);
        nameBuffer.position(0);
        ByteBuffer messageBuffer = ByteBuffer.allocate(4 + nameBuffer.capacity() + this.bytes.length);
        messageBuffer.putInt(nameBuffer.capacity());
        messageBuffer.put(nameBuffer);
        messageBuffer.put(this.bytes);
        return messageBuffer;
    }

    public String getClassName() {
        return this.className;
    }

    public byte[] getByteCode() {
        return this.bytes;
    }

    protected ByteBuffer encode(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer;
    }

    protected String decode(ByteBuffer buffer) {
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = charsetDecoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        return charBuffer.toString();
    }
}

