/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.ow2.carol.cmi.smart.api.Message;

public class FactoryNameAnswer
implements Message {
    private String factoryName = null;

    public FactoryNameAnswer(ByteBuffer buffer) {
        Charset charset = Charset.forName("us-ascii");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer urlsBuffer = decoder.decode(buffer);
            this.factoryName = urlsBuffer.toString();
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
    }

    public FactoryNameAnswer(String factoryName) {
        this.factoryName = factoryName;
    }

    public ByteBuffer getMessage() {
        ByteBuffer message = this.getMessageContent();
        int length = 5;
        if (message != null) {
            length += message.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(this.getOperationCode());
        if (message != null) {
            byteBuffer.putInt(message.capacity());
        }
        if (message != null) {
            message.position(0);
            byteBuffer.put(message);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public ByteBuffer getMessageContent() {
        ByteBuffer factoryNameBuffer = this.encode(this.factoryName);
        return factoryNameBuffer;
    }

    public byte getOperationCode() {
        return 8;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected ByteBuffer encode(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer;
    }
}

