/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.carol.cmi.smart.api.Message;
import org.ow2.carol.cmi.smart.server.SmartEndPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderURLsAnswer
implements Message {
    private static Logger logger = Logger.getLogger(SmartEndPoint.class.getName());
    private List<String> providerURLs = null;
    private static int intlength = 4;

    public ProviderURLsAnswer(ByteBuffer buffer) {
        ArrayList<String> urls = new ArrayList<String>();
        int size = buffer.getInt(buffer.position());
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            ByteBuffer newbuf = buffer.duplicate();
            int urlsize = newbuf.getInt(buffer.position() + intlength + offset);
            newbuf.limit(buffer.position() + intlength + offset + intlength + urlsize);
            newbuf.position(buffer.position() + intlength + offset + intlength);
            ByteBuffer urlbuf = newbuf.duplicate();
            String url = this.decode(urlbuf);
            urls.add(url);
            offset = urlsize + intlength;
        }
        this.providerURLs = urls;
    }

    public ProviderURLsAnswer(List<String> providerURLs) {
        this.providerURLs = providerURLs;
    }

    @Override
    public ByteBuffer getMessage() {
        ByteBuffer message = this.getMessageContent();
        int length = 5;
        if (message != null) {
            length += message.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(this.getOperationCode());
        if (message != null) {
            byteBuffer.putInt(message.capacity());
        }
        if (message != null) {
            message.position(0);
            byteBuffer.put(message);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    @Override
    public byte getOperationCode() {
        return 6;
    }

    public ByteBuffer getMessageContent() {
        if (this.providerURLs != null) {
            String[] urlsArray = new String[this.providerURLs.size()];
            for (int n = 0; n < this.providerURLs.size(); ++n) {
                urlsArray[n] = this.providerURLs.toArray()[n].toString();
            }
            int length = this.getMessageLength(this.providerURLs);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.putInt(this.providerURLs.size());
            for (int i = 0; i < this.providerURLs.size(); ++i) {
                buffer.putInt(urlsArray[i].length());
                ByteBuffer urlbuffer = ByteBuffer.allocate(urlsArray[i].getBytes().length);
                urlbuffer = this.encode(urlsArray[i]);
                urlbuffer.position(0);
                buffer.put(urlbuffer);
            }
            buffer.position(0);
            return buffer;
        }
        logger.log(Level.INFO, "The providers url List should not be null.");
        return null;
    }

    private int getMessageLength(List<String> providerURLs) {
        int length = 0;
        if (providerURLs != null) {
            int size = providerURLs.size();
            for (int i = 0; i < size; ++i) {
                length += providerURLs.toArray()[i].toString().getBytes().length + intlength;
            }
            return length + intlength;
        }
        logger.log(Level.INFO, "The given List should not be null.");
        return 0;
    }

    public List<String> getProviderURLs() {
        return this.providerURLs;
    }

    protected ByteBuffer encode(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer;
    }

    protected String decode(ByteBuffer buffer) {
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = charsetDecoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        return charBuffer.toString();
    }
}

