/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.ow2.carol.cmi.smart.api.Message;

public class ResourceNotFound
implements Message {
    private String resourceName = null;

    public ResourceNotFound(String resourceName) {
        this.resourceName = resourceName;
    }

    public ResourceNotFound(ByteBuffer buffer) {
        this.resourceName = this.decode(buffer);
    }

    public ByteBuffer getMessage() {
        ByteBuffer message = this.getMessageContent();
        int length = 5;
        if (message != null) {
            length += message.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(this.getOperationCode());
        if (message != null) {
            byteBuffer.putInt(message.capacity());
        }
        if (message != null) {
            message.position(0);
            byteBuffer.put(message);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    private ByteBuffer getMessageContent() {
        ByteBuffer nameBuffer = this.encode(this.resourceName);
        return nameBuffer;
    }

    public byte getOperationCode() {
        return 9;
    }

    protected String decode(ByteBuffer buffer) {
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = charsetDecoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        return charBuffer.toString();
    }

    protected ByteBuffer encode(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer;
    }
}

