/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.carol.cmi.smart.api.SmartConnector;
import org.ow2.carol.cmi.smart.message.Attachment;
import org.ow2.carol.cmi.smart.message.ClassAnswer;
import org.ow2.carol.cmi.smart.message.ClassNotFound;
import org.ow2.carol.cmi.smart.message.ClassRequest;
import org.ow2.carol.cmi.smart.message.FactoryNameAnswer;
import org.ow2.carol.cmi.smart.message.ProviderURLsAnswer;
import org.ow2.carol.cmi.smart.message.ResourceAnswer;
import org.ow2.carol.cmi.smart.message.ResourceNotFound;
import org.ow2.carol.cmi.smart.message.ResourceRequest;
import org.ow2.carol.cmi.smart.server.SmartServerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartEndPoint
implements Runnable {
    private static Logger logger = Logger.getLogger(SmartEndPoint.class.getName());
    private static final int MAX_LENGTH_INCOMING_MSG = 2048;
    private static final int BUFFER_LENGTH = 3000;
    private static final int DEFAULT_PORT_NUMBER = 2505;
    private int portNumber = 2505;
    private Selector selector = null;
    private ServerSocketChannel serverSocketChannel = null;
    private SelectionKey selectionKey = null;
    private boolean started = false;
    private SmartConnector connector = null;

    public void start() throws SmartServerException {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Cannot open a new selector.");
            throw new SmartServerException("Cannot open a new selector.", e);
        }
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Cannot open a new server socket channel.");
            throw new SmartServerException("Cannot open a new server socket channel.", e);
        }
        try {
            InetSocketAddress endpoint = new InetSocketAddress(this.portNumber);
            this.serverSocketChannel.socket().bind(endpoint);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Port Number" + this.portNumber + "can't be used");
            throw new SmartServerException("Port Number" + this.portNumber + "can't be used", e);
        }
        try {
            this.selectionKey = this.serverSocketChannel.register(this.selector, 16);
        }
        catch (ClosedChannelException e) {
            logger.log(Level.INFO, "Cannot select this server as an listener");
            throw new SmartServerException("Cannot select this server as an listener", e);
        }
        this.started = true;
        new Thread(this).start();
        logger.log(Level.INFO, "SmartClient Endpoint listening on port '" + this.portNumber + "'.");
    }

    private List<String> getproviderURLs(String protocol) {
        List providerURLs = null;
        try {
            providerURLs = this.connector.getProviderURLs(protocol);
            return providerURLs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return providerURLs;
        }
    }

    private String getFactoryName(String protocol) {
        String factoryName = this.connector.getInitialContextFactoryName(protocol);
        return factoryName;
    }

    @Override
    public void run() {
        this.selectorHandle();
    }

    private void selectorHandle() {
        while (this.started) {
            int keys = 0;
            try {
                keys = this.selector.select();
            }
            catch (IOException e) {
                logger.log(Level.INFO, "this selector is closed", e);
                this.started = false;
            }
            if (keys == 0) continue;
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> isSelectedKeys = selectedKeys.iterator();
            while (isSelectedKeys.hasNext()) {
                SelectionKey selectKey = isSelectedKeys.next();
                isSelectedKeys.remove();
                if (selectKey == this.selectionKey) {
                    if (!selectKey.isAcceptable()) continue;
                    this.readyHandle();
                    continue;
                }
                if (selectKey.isReadable()) {
                    try {
                        this.readHandle(selectKey);
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Unable to read request data from the client.", e);
                    }
                    continue;
                }
                if (!selectKey.isWritable()) continue;
                try {
                    this.writeHandle(selectKey);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Unable to write answer data to the client.", e);
                }
            }
        }
    }

    private void readyHandle() {
        try {
            SocketChannel clientConnection = this.serverSocketChannel.accept();
            clientConnection.configureBlocking(false);
            clientConnection.register(this.selector, 1, new Attachment());
        }
        catch (IOException e) {
            logger.log(Level.FINE, "this channel is closed.", e);
        }
    }

    private void writeHandle(SelectionKey selectKey) throws IOException {
        SocketChannel serverConnection = (SocketChannel)selectKey.channel();
        ByteBuffer byteBuffer = (ByteBuffer)selectKey.attachment();
        if (byteBuffer.hasRemaining()) {
            serverConnection.write(byteBuffer);
        } else {
            serverConnection.close();
        }
    }

    private void readHandle(SelectionKey selectKey) throws IOException {
        Attachment attachment;
        ByteBuffer byteBuffer;
        SocketChannel clientConnection = (SocketChannel)selectKey.channel();
        int bytes = clientConnection.read(byteBuffer = (attachment = (Attachment)selectKey.attachment()).getByteBuffer());
        if (bytes == -1) {
            selectKey.cancel();
            clientConnection.close();
        }
        if (byteBuffer.position() >= 5) {
            byte operationCode = byteBuffer.get(0);
            int length = byteBuffer.getInt(1);
            if (length < 0) {
                this.selectionKey.cancel();
                clientConnection.close();
                throw new IllegalStateException("Invalid length for client '" + length + "'.");
            }
            if (length > 2048) {
                this.selectionKey.cancel();
                clientConnection.close();
                throw new IllegalStateException("Length too big, max length = '2048', current = '" + length + "'.");
            }
            if (byteBuffer.position() >= 5 + length) {
                byteBuffer.limit(5 + length);
                ByteBuffer dataBuffer = byteBuffer.duplicate();
                dataBuffer.position(5);
                try {
                    switch (operationCode) {
                        case 1: {
                            this.classRequest(selectKey, dataBuffer);
                            break;
                        }
                        case 3: {
                            this.resourceRequest(selectKey, dataBuffer);
                            break;
                        }
                        case 5: {
                            this.providerURLsRequest(selectKey, dataBuffer);
                            break;
                        }
                        case 7: {
                            this.factoryNameRequest(selectKey, dataBuffer);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.selectionKey.cancel();
                    clientConnection.close();
                    throw new IllegalStateException("Cannot handle request with opCode '" + operationCode + "'.", e);
                }
            }
        }
    }

    private void providerURLsRequest(SelectionKey selectKey, ByteBuffer dataBuffer) {
        String protocol = null;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = decoder.decode(dataBuffer);
            protocol = charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        selectKey.interestOps(4);
        List<String> providerURLs = this.getproviderURLs(protocol);
        ProviderURLsAnswer providerURLAnswer = new ProviderURLsAnswer(providerURLs);
        selectKey.attach(providerURLAnswer.getMessage());
    }

    private void factoryNameRequest(SelectionKey selectKey, ByteBuffer dataBuffer) {
        String protocol = null;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = decoder.decode(dataBuffer);
            protocol = charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        selectKey.interestOps(4);
        String factoryName = this.getFactoryName(protocol);
        FactoryNameAnswer factoryNameAnswer = new FactoryNameAnswer(factoryName);
        selectKey.attach(factoryNameAnswer.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceRequest(SelectionKey selectKey, ByteBuffer dataBuffer) throws IOException {
        ResourceRequest resourceRequest = new ResourceRequest(dataBuffer);
        String resourceName = resourceRequest.getResourceName();
        selectKey.interestOps(4);
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            ResourceNotFound resourceNotFound = new ResourceNotFound(resourceName);
            selectKey.attach(resourceNotFound.getMessage());
            logger.log(Level.FINE, "Resource '" + resourceName + "' not found");
            return;
        }
        InputStream inputStream = url.openStream();
        byte[] bytes = null;
        try {
            bytes = SmartEndPoint.readClass(inputStream);
        }
        finally {
            inputStream.close();
        }
        ResourceAnswer resourceAnswer = new ResourceAnswer(resourceName, bytes);
        selectKey.attach(resourceAnswer.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void classRequest(SelectionKey selectKey, ByteBuffer dataBuffer) {
        ClassRequest classRequest = new ClassRequest(dataBuffer);
        String className = classRequest.getClassName();
        selectKey.interestOps(4);
        String encodedClassName = className.replaceAll("\\.", "/").concat(".class");
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(encodedClassName);
        if (inputStream == null) {
            ClassNotFound classNotFound = new ClassNotFound(className);
            selectKey.attach(classNotFound.getMessage());
            logger.log(Level.FINE, "Class '" + className + "' not found");
            return;
        }
        byte[] bytes = null;
        try {
            try {
                bytes = SmartEndPoint.readClass(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ClassAnswer classAnswer = new ClassAnswer(className, bytes);
        selectKey.attach(classAnswer.getMessage());
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 3000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void setSmartConnector(SmartConnector connector) {
        this.connector = connector;
    }

    public void setPortNumber(int number) {
        this.portNumber = number;
    }

    public void stop() throws SmartServerException {
        this.started = false;
        this.selector.wakeup();
    }
}

