/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.smart.spi;

import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.carol.cmi.smart.client.SmartClassLoader;
import org.ow2.carol.cmi.smart.spi.SmartContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class SmartContextFactory
implements InitialContextFactory {
    private static Log logger = LogFactory.getLog(SmartContextFactory.class);
    public static final String WRAPPED_PROTOCOL = "cmi.context.wrapped.protocol";
    public static final String INITIAL_PROVIDER_URLS = "cmi.context.provider.urls";
    public static final String WRAPPED_INITIAL_CONTEXT_FACTORY = "cmi.context.wrapped.factory";
    public static final String CMI_FACTORY = "org.ow2.carol.cmi.jndi.context.CMIInitialContextFactory";
    public static final String CMI_CONFIG_SMART = "cmi.config.smart";
    private static final String DEFAULT_URL = "smart://localhost:2505";
    private static String wrappedFactoryName = null;
    public static final String CMI_SMART_FACTORY = "cmi.smart.delegate.factory";
    private static SmartClassLoader classLoader = null;
    private static List<String> providerURLs = null;
    private static final String DEFAULT_PROTOCOL = "jrmp";

    public SmartContextFactory() {
        System.setProperty(CMI_SMART_FACTORY, this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        if (classLoader == null) {
            String currentProviderURL = DEFAULT_URL;
            String host = this.getHost(currentProviderURL);
            int port = this.getPort(currentProviderURL);
            classLoader = new SmartClassLoader(host, port);
        }
        if (wrappedFactoryName == null) {
            wrappedFactoryName = classLoader.getWrappedFactoryName(DEFAULT_PROTOCOL);
            logger.info((Object)("Got the wrapped factory '" + wrappedFactoryName + "'."), new Object[0]);
        }
        if (providerURLs == null) {
            providerURLs = classLoader.getProviderURLs(DEFAULT_PROTOCOL);
            logger.info((Object)("Got a list of remote PROVIDER_URLs." + providerURLs), new Object[0]);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            environment.put(CMI_CONFIG_SMART, true);
            environment.put("java.naming.factory.initial", CMI_FACTORY);
            environment.put(WRAPPED_INITIAL_CONTEXT_FACTORY, wrappedFactoryName);
            environment.put(INITIAL_PROVIDER_URLS, providerURLs);
            environment.put(WRAPPED_PROTOCOL, DEFAULT_PROTOCOL);
            logger.info((Object)"The smart context is created!", new Object[0]);
            SmartContext smartContext = new SmartContext(new InitialContext(environment), classLoader);
            return smartContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public String getHost(String url) {
        String[] compos = url.split(":");
        String parthost = compos[1];
        String[] partcompos = parthost.split("/");
        String host = partcompos[partcompos.length - 1];
        return host;
    }

    public int getPort(String url) {
        String[] compos = url.split(":");
        String port = compos[compos.length - 1];
        int i = port.indexOf(",");
        if (i > 0) {
            String[] portcompos = port.split(",");
            port = portcompos[0];
        }
        return new Integer(port);
    }
}

