
/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: Operations.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.smart.api;

/**
 * Describes all protocol's value used to exchange messages.
 * @author The new CMI team
 * @author Florent Benoit
 */
public interface Operations {

    /**
     * Client asking for a Class.
     */
    byte CLASS_REQUEST = (byte) 0x01;

    /**
     * Server answering for a class.
     */
    byte CLASS_ANSWER = (byte) 0x02;

    /**
     * Client asking for a resource.
     */
    byte RESOURCE_REQUEST = (byte) 0x03;

    /**
     * Server answering for a resource.
     */
    byte RESOURCE_ANSWER = (byte) 0x04;

    /**
     * Client asking for a provider url.
     */
    byte PROVIDER_URLS_REQUEST = (byte) 0x05;

    /**
     * Server answering for a provider url.
     */
    byte PROVIDER_URLS_ANSWER = (byte) 0x06;

    /**
     * Client asking for a factory name.
     */
    byte FACTORY_NAME_REQUEST = (byte) 0x07;

    /**
     * Server answering for a factory name.
     */
    byte FACTORY_NAME_ANSWER = (byte) 0x08;

    /**
     * Server answering for a resource that was not found.
     */
    byte RESOURCE_NOT_FOUND = (byte) 0x09;

    /**
     * Server answering for a class that was not found.
     */
    byte CLASS_NOT_FOUND = (byte) 0x0A;


}