/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.core.activators.BundleDeployer;
import org.ow2.chameleon.core.activators.ConfigDeployer;
import org.ow2.chameleon.core.activators.CoreActivator;
import org.ow2.chameleon.core.activators.DirectoryMonitor;
import org.ow2.chameleon.core.activators.LogActivator;
import org.ow2.chameleon.core.utils.FrameworkManager;
import org.ow2.chameleon.core.utils.LogbackUtil;
import org.slf4j.Logger;

public class Chameleon {
    private final FrameworkManager manager;
    private Logger logger;
    private List<BundleActivator> activators = new ArrayList<BundleActivator>();

    public Chameleon(File basedir, boolean interactive) throws Exception {
        ChameleonConfiguration configuration = new ChameleonConfiguration(basedir);
        configuration.setInteractiveModeEnabled(interactive);
        configuration.loadChameleonProperties();
        configuration.loadSystemProperties();
        configuration.initFrameworkConfiguration();
        this.logger = Chameleon.initializeLoggingSystem(configuration);
        this.initializeActivatorList(configuration);
        this.manager = new FrameworkManager(this, configuration);
        this.manager.addActivators(this.activators);
    }

    public Chameleon(ChameleonConfiguration configuration) throws Exception {
        configuration.setInteractiveModeEnabled(false);
        configuration.loadChameleonProperties();
        configuration.loadSystemProperties();
        configuration.initFrameworkConfiguration();
        this.logger = Chameleon.initializeLoggingSystem(configuration);
        this.initializeActivatorList(configuration);
        this.manager = new FrameworkManager(this, configuration);
        this.manager.addActivators(this.activators);
    }

    public Chameleon(boolean interactive) throws Exception {
        this(new File(""), interactive);
    }

    public Chameleon(String basedir, boolean interactive) throws Exception {
        this(new File(basedir), interactive);
    }

    public static Logger initializeLoggingSystem(ChameleonConfiguration configuration) throws IOException {
        Logger log = LogbackUtil.configure(configuration);
        if (configuration.isInteractiveModeEnabled()) {
            log.debug("interactive mode enabled");
        }
        return log;
    }

    private void initializeActivatorList(ChameleonConfiguration configuration) throws IOException {
        File core = configuration.getDirectory("chameleon.core", true);
        if (core == null) {
            throw new IllegalArgumentException("The chameleon.core property is missing in the conf/chameleon.properties file.");
        }
        File runtime = configuration.getDirectory("chameleon.runtime", true);
        if (runtime == null) {
            throw new IllegalArgumentException("The chameleon.runtime property is missing in the conf/chameleon.properties file.");
        }
        File application = configuration.getDirectory("chameleon.application", true);
        if (application == null) {
            throw new IllegalArgumentException("The chameleon.application property is missing in the conf/chameleon.properties file.");
        }
        this.activators.add(new LogActivator(this.logger));
        this.activators.add(new CoreActivator(core, configuration.isInteractiveModeEnabled()));
        boolean monitoringRuntime = configuration.getBoolean("chameleon.runtime.monitoring", false);
        boolean monitoringApplication = configuration.getBoolean("chameleon.application.monitoring", true);
        int monitoringPeriod = configuration.getInt("chameleon.monitoring.period", 2000);
        if (monitoringRuntime) {
            this.activators.add(new DirectoryMonitor(runtime, monitoringPeriod));
        } else {
            this.activators.add(new DirectoryMonitor(runtime));
        }
        if (monitoringApplication) {
            this.activators.add(new DirectoryMonitor(application, monitoringPeriod));
        } else {
            this.activators.add(new DirectoryMonitor(application));
        }
        this.activators.add(new BundleDeployer());
        this.activators.add(new ConfigDeployer());
    }

    public void start() throws BundleException {
        this.manager.start();
    }

    public void stop() throws BundleException, InterruptedException {
        this.logger.info("Stopping Chameleon");
        this.manager.stop();
        this.logger.info("Chameleon stopped");
    }

    public BundleContext context() {
        return this.manager.get().getBundleContext();
    }

    public Framework framework() {
        return this.manager.get();
    }
}

