/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.chameleon.core.services.AbstractDeployer;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.utils.BundleHelper;

public class BundleDeployer
extends AbstractDeployer
implements BundleActivator {
    Map<File, Bundle> bundles = new HashMap<File, Bundle>();
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(Deployer.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    @Override
    public boolean accept(File file) {
        return file.getName().endsWith(".jar") && (!file.isFile() || BundleHelper.isBundle(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileCreate(File file) {
        this.logger.debug("File creation event received for {}", (Object)file.getAbsoluteFile());
        BundleDeployer bundleDeployer = this;
        synchronized (bundleDeployer) {
            if (this.bundles.containsKey(file)) {
                Bundle bundle = this.bundles.get(file);
                this.logger.info("Updating bundle {} - {}", (Object)bundle.getSymbolicName(), (Object)file.getAbsoluteFile());
                try {
                    bundle.update();
                    this.tryToStartUnstartedBundles(bundle);
                }
                catch (BundleException e) {
                    this.logger.error("Error during bundle update {} from {}", new Object[]{bundle.getSymbolicName(), file.getAbsoluteFile(), e});
                }
            } else {
                this.logger.info("Installing bundle from {}", (Object)file.getAbsoluteFile());
                try {
                    Bundle bundle = this.context.installBundle("reference:" + file.toURI().toURL().toExternalForm());
                    this.bundles.put(file, bundle);
                    if (!BundleHelper.isFragment(bundle)) {
                        this.logger.info("Starting bundle {} - {}", (Object)bundle.getSymbolicName(), (Object)file.getAbsoluteFile());
                        bundle.start();
                    }
                    this.tryToStartUnstartedBundles(bundle);
                }
                catch (Exception e) {
                    this.logger.error("Error during bundle installation of {}", new Object[]{file.getAbsoluteFile(), e});
                }
            }
        }
    }

    private void tryToStartUnstartedBundles(Bundle bundle) {
        for (Bundle b : this.bundles.values()) {
            if (bundle == b || b.getState() == 32 || BundleHelper.isFragment(b)) continue;
            this.logger.debug("Trying to start bundle {} after having installed bundle {}", (Object)b.getSymbolicName(), (Object)bundle.getSymbolicName());
            try {
                b.start();
            }
            catch (BundleException e) {
                this.logger.debug("Failed to start bundle {} after having installed bundle {}", new Object[]{b.getSymbolicName(), bundle.getSymbolicName(), e});
            }
        }
    }

    @Override
    public void open(Collection<File> files) {
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        for (File file : files) {
            try {
                Bundle bundle = this.context.installBundle("reference:" + file.toURI().toURL().toExternalForm());
                this.bundles.put(file, bundle);
                if (BundleHelper.isFragment(bundle)) continue;
                toStart.add(bundle);
            }
            catch (Exception e) {
                this.logger.error("Error during bundle installation of {}", new Object[]{file.getAbsoluteFile(), e});
            }
        }
        for (Bundle bundle : toStart) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                this.logger.error("Error during the starting of {}", new Object[]{bundle.getSymbolicName(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileDelete(File file) {
        Bundle bundle;
        BundleDeployer bundleDeployer = this;
        synchronized (bundleDeployer) {
            bundle = this.bundles.remove(file);
        }
        if (bundle != null) {
            try {
                this.logger.info("Uninstalling bundle {}", (Object)bundle.getSymbolicName());
                bundle.uninstall();
            }
            catch (BundleException e) {
                this.logger.error("Error during the un-installation of {}", new Object[]{bundle.getSymbolicName(), e});
            }
        }
    }
}

