/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.ExtensionBasedDeployer;

public class ConfigDeployer
extends ExtensionBasedDeployer
implements BundleActivator,
ServiceListener {
    private static final Configuration UNMANAGED_CONFIGURATION = new Configuration(){

        public String getPid() {
            return "not managed";
        }

        public Dictionary getProperties() {
            return null;
        }

        public void update(Dictionary dictionary) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getFactoryPid() {
            return this.getPid();
        }

        public void update() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getBundleLocation() {
            return null;
        }

        public void setBundleLocation(String s) {
        }
    };
    Map<File, Configuration> configurations = new HashMap<File, Configuration>();
    private BundleContext context;

    public ConfigDeployer() {
        super("cfg");
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(Deployer.class, (Object)this, null);
        context.addServiceListener((ServiceListener)this, "(objectClass=" + ConfigurationAdmin.class.getName() + ")");
    }

    public void stop(BundleContext context) throws Exception {
        this.removeAllConfigurations();
    }

    private Properties read(File file) throws IOException {
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(file);
        p.load(in);
        ((InputStream)in).close();
        return p;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - ".cfg".length());
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndApplyConfiguration(File file, ConfigurationAdmin admin) throws Exception {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            if (admin == null) {
                this.logger.warn("Cannot apply configuration " + file.getName() + " - no configuration admin");
                this.configurations.put(file, UNMANAGED_CONFIGURATION);
            } else {
                Properties properties = this.read(file);
                String[] pid = this.parsePid(file.getName());
                Hashtable<String, String> ht = new Hashtable<String, String>();
                for (String k : properties.stringPropertyNames()) {
                    ht.put(k, properties.getProperty(k));
                }
                Configuration config = this.configurations.get(file);
                if (config == null && (config = this.getConfiguration(pid[0], pid[1], admin)).getBundleLocation() != null) {
                    config.setBundleLocation(null);
                }
                this.logger.info("Updating configuration {} in the configuration admin, configuration: {}", (Object)config.getPid(), this.configurations);
                config.update(ht);
                this.configurations.put(file, config);
            }
        }
    }

    private ConfigurationAdmin getConfigurationAdmin() throws Exception {
        ServiceReference ref = this.context.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            return null;
        }
        return (ConfigurationAdmin)this.context.getService(ref);
    }

    Configuration getConfiguration(String pid, String factoryPid, ConfigurationAdmin cm) throws Exception {
        Configuration newConfiguration = factoryPid != null ? cm.createFactoryConfiguration(pid, "?") : cm.getConfiguration(pid, "?");
        return newConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileCreate(File file) {
        this.logger.info("File creation event received for {}", (Object)file.getAbsoluteFile());
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            try {
                ConfigurationAdmin admin = this.getConfigurationAdmin();
                this.readAndApplyConfiguration(file, admin);
            }
            catch (Exception e) {
                this.logger.error("Cannot find the configuration admin service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileDelete(File file) {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            Configuration configuration = this.configurations.remove(file);
            if (configuration != UNMANAGED_CONFIGURATION) {
                try {
                    this.logger.info("Deleting configuration {}", (Object)configuration.getPid());
                    configuration.delete();
                }
                catch (Exception e) {
                    this.logger.error("Cannot delete configuration from {}", (Object)configuration.getPid());
                }
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            ConfigurationAdmin admin = (ConfigurationAdmin)this.context.getService(event.getServiceReference());
            this.processAllConfigurations(admin);
        } else if (event.getType() == 4) {
            this.removeAllConfigurations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConfigurations() {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            for (Map.Entry<File, Configuration> entry : this.configurations.entrySet()) {
                if (entry.getValue() == UNMANAGED_CONFIGURATION) continue;
                try {
                    this.logger.info("Deleting configuration {}", (Object)entry.getValue().getPid());
                    entry.getValue().delete();
                }
                catch (Exception e) {
                    this.logger.error("Cannot delete configuration from {}", (Object)entry.getKey().getAbsoluteFile());
                }
            }
        }
        this.configurations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllConfigurations(ConfigurationAdmin admin) {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            for (Map.Entry<File, Configuration> entry : this.configurations.entrySet()) {
                if (entry.getValue() != UNMANAGED_CONFIGURATION) continue;
                try {
                    this.readAndApplyConfiguration(entry.getKey(), admin);
                }
                catch (Exception e) {
                    this.logger.error("Cannot apply configuration from {}", (Object)entry.getKey().getAbsoluteFile());
                }
            }
        }
    }
}

