/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.ow2.chameleon.core.services.Deployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedDeployer
implements Deployer {
    private final File directory;
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public DirectoryBasedDeployer(File directory) {
        this.directory = directory;
    }

    public DirectoryBasedDeployer(String directory) {
        this.directory = new File(directory);
    }

    @Override
    public boolean accept(File file) {
        try {
            return FileUtils.directoryContains((File)this.directory, (File)file);
        }
        catch (IOException e) {
            this.logger.debug("Cannot check if {} is contained in {}", new Object[]{file.getAbsolutePath(), this.directory.getAbsolutePath(), e});
            return false;
        }
    }

    @Override
    public void onFileCreate(File file) {
    }

    @Override
    public void onFileChange(File file) {
        this.onFileCreate(file);
    }

    @Override
    public void onFileDelete(File file) {
    }

    @Override
    public void open(Collection<File> files) {
        for (File file : files) {
            this.onFileCreate(file);
        }
    }

    @Override
    public void close() {
    }
}

