/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.ow2.chameleon.core.services.Deployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBasedDeployer
implements Deployer {
    private final List<String> extensions;
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public ExtensionBasedDeployer(String[] extensions) {
        this.extensions = ImmutableList.copyOf((Object[])extensions);
    }

    public ExtensionBasedDeployer(String extension) {
        this.extensions = ImmutableList.of((Object)extension);
    }

    public ExtensionBasedDeployer(List<String> extensions) {
        this.extensions = ImmutableList.copyOf(extensions);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        return this.extensions.contains(extension);
    }

    @Override
    public void onFileCreate(File file) {
    }

    @Override
    public void onFileChange(File file) {
        this.onFileCreate(file);
    }

    @Override
    public void onFileDelete(File file) {
    }

    @Override
    public void open(Collection<File> files) {
        for (File file : files) {
            this.onFileCreate(file);
        }
    }

    @Override
    public void close() {
    }
}

