/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;

public class BundleHelper {
    public static boolean isBundle(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(file);
                return jar.getManifest() != null && jar.getManifest().getMainAttributes() != null && jar.getManifest().getMainAttributes().getValue("Bundle-ManifestVersion") != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (file.isDirectory()) {
            File manifestFile = new File(file, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                return false;
            }
            try {
                Manifest manifest = new Manifest(new FileInputStream(manifestFile));
                return manifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers.get("Fragment-Host") != null;
    }
}

