/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.ow2.chameleon.core.utils.StringUtils;

public class ChameleonConfiguration
extends HashMap<String, String> {
    private static final String CONFIGURATION_ADMIN_PACKAGE_VERSION = "1.5.0";
    private static final String LOG_SERVICE_PACKAGE_VERSION = "1.3.0";
    private static final String SLF4J_PACKAGE_VERSION = "1.7.2";
    private final File baseDirectory;
    private boolean interactiveModeEnabled;

    public ChameleonConfiguration(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void loadChameleonProperties() throws IOException {
        File file = new File(this.baseDirectory.getAbsoluteFile(), "conf/chameleon.properties");
        Properties ps = new Properties();
        ps.putAll((Map<?, ?>)System.getProperties());
        if (file.isFile()) {
            ps.load(new FileInputStream(file));
        }
        Enumeration<Object> keys = ps.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = (String)ps.get(k);
            v = StringUtils.substVars(v, k, null, ps);
            if (k.endsWith("extra") && this.containsKey(k)) {
                this.put(k, (String)this.get(k) + "," + v);
                continue;
            }
            this.put(k, v);
        }
    }

    public String get(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return (String)this.get(key);
        }
        return defaultValue;
    }

    public File getDirectory(String key, boolean create) {
        String path = (String)this.get(key);
        if (path == null) {
            return null;
        }
        File dir = new File(this.baseDirectory.getAbsoluteFile(), path);
        if (create && !dir.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                return null;
            }
        }
        return dir;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = (String)this.get(key);
        if (key == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = (String)this.get(key);
        if (key == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public File getFile(String key, boolean create) {
        String path = (String)this.get(key);
        File file = new File(this.baseDirectory.getAbsoluteFile(), path);
        if (create && !file.isFile()) {
            try {
                FileUtils.forceMkdir((File)file.getParentFile());
                file.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        return file;
    }

    public void initFrameworkConfiguration() {
        if (!this.containsKey("org.osgi.framework.storage.clean")) {
            this.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (!this.containsKey("ipojo.log.level")) {
            this.put("ipojo.log.level", "WARNING");
        }
        if (!this.containsKey("org.osgi.framework.storage")) {
            this.put("org.osgi.framework.storage", this.baseDirectory.getAbsolutePath() + "/chameleon-cache");
        }
        if (!this.containsKey("org.osgi.framework.system.packages.extra")) {
            this.put("org.osgi.framework.system.packages.extra", this.getPackagesExportedByFramework());
        } else {
            String pcks = (String)this.get("org.osgi.framework.system.packages.extra");
            this.put("org.osgi.framework.system.packages.extra", this.getPackagesExportedByFramework() + "," + pcks);
        }
    }

    private String getPackagesExportedByFramework() {
        return "org.osgi.service.cm; version=1.5.0,org.osgi.service.log; version=1.3.0,org.slf4j; version=1.7.2,org.slf4j.impl; version=1.7.2,org.slf4j.spi; version=1.7.2,org.slf4j.helpers; version=1.7.2,org.ow2.chameleon.core.services";
    }

    public void loadSystemProperties() throws IOException {
        File file = new File(this.baseDirectory.getAbsolutePath(), "conf/system.properties");
        Properties ps = new Properties();
        if (file.isFile()) {
            ps.load(new FileInputStream(file));
            Enumeration<?> e = ps.propertyNames();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String v = StringUtils.substVars((String)ps.get(k), k, null, System.getProperties());
                System.setProperty(k, v);
            }
        }
    }

    public File getBaseDirectory() {
        return this.baseDirectory.getAbsoluteFile();
    }

    public boolean isInteractiveModeEnabled() {
        return this.interactiveModeEnabled;
    }

    public void setInteractiveModeEnabled(boolean interactiveModeEnabled) {
        this.interactiveModeEnabled = interactiveModeEnabled;
    }

    public File getRelativeFile(String path) {
        return new File(this.baseDirectory.getAbsoluteFile(), path);
    }
}

