/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import org.ow2.chameleon.core.Chameleon;

public class Main {
    private Main() {
    }

    public static void main(String[] args) {
        Chameleon chameleon = null;
        try {
            chameleon = Main.createChameleon(args);
        }
        catch (Exception e) {
            System.err.println("Cannot initialize Chameleon : " + e.getMessage());
            e.printStackTrace();
        }
        if (chameleon == null) {
            return;
        }
        Main.registerShutdownHook(chameleon);
        try {
            chameleon.start();
        }
        catch (Exception e) {
            System.err.println("Cannot start Chameleon : " + e.getMessage());
        }
    }

    public static Chameleon createChameleon(String[] args) throws Exception {
        boolean interactive = Main.isInteractiveModeEnabled(args);
        return new Chameleon(interactive);
    }

    private static void registerShutdownHook(final Chameleon chameleon) {
        Runtime runtime = Runtime.getRuntime();
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                try {
                    if (chameleon != null) {
                        chameleon.stop();
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot stop Chameleon correctly : " + e.getMessage());
                }
            }
        };
        runtime.addShutdownHook(new Thread(hook));
    }

    private static boolean isInteractiveModeEnabled(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("--interactive")) continue;
            return true;
        }
        return false;
    }
}

